
#include <math.h>
#include <qapplication.h>
#include <qmainwindow.h>
#include <qmotifplusstyle.h>

/** see ../widgets dir */
#include "qsplotview.h"
//#include "qsworkbook.h"
#include "qsaxes2d.h"
#include "qscurve.h"
#include "qsclegend.h"

// implementation of QSMatrix
class Curve1 : public QSMatrix {
 public:
    Curve1() {}
    ~Curve1() {}
    int cols() const { return 1; }
    int rows() const { return 100; }
    double value( int row, int col ) { return sin( row/10.0 )*100.0; }
    };


int main( int argc, char ** argv ) {
    QApplication a( argc, argv );
    QApplication::setStyle( new QMotifPlusStyle() );

    QMainWindow *mw = new QMainWindow();
    mw->setCaption( "plot2d demo" );

    // create a workbook with a one empty page.
    QSWorkbook *doc = new QSWorkbook( mw );
    doc->clear();
    doc->pageAdd( new QSPage() );

    // create the view and set it as main widget in app window
    QSPlotView  *view = new QSPlotView( mw );
    view->setFullPage( true );
    mw->setCentralWidget( view );

    // set workbook to be displayed
    view->setWorkbook( doc );

    // create axes object
    QSAxes2D *axes = new QSAxes2D();
    // axes doesn't inherit QSCObject ( problems with multiple inheritance )
    // so we must use axes->shadowObject() instead
    doc->page(0)->objects()->add( axes->shadowObject() );

    // create dataset
    QSCurve *c = new QSCurve( axes );
    // set data to be displayed
    c->setMatrix( QSCurve::YVector, new Curve1() );
    c->setTitle( "Sample" );
    axes->plotAdd( c );

    // setting attributes
    QSGLine l( QSGLine::Dash );
    l.color.set( 255, 0, 0 );
    c->setLine( QSCurve::BaseLine, l );
    
    // adding legend
    doc->page(0)->objects()->add( new QSCLegend(axes) );

    mw->show();
    a.connect( &a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()) );
    return a.exec();
}
