# Copyright (c) 2008 Hideki Ikemoto
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

require 'singleton'

class Config
  include Singleton

  def initialize
    @config = KDE::Config.new(ENV['HOME'] + "/.kita/config")
  end

  def user_id
    config = @config.group("Account")
    config.readEntry("UserId", "")
  end

  def user_id=(user_id)
    config = @config.group("Account")
    config.writeEntry("UserId", user_id)
    config.sync
  end

  def password
    config = @config.group("Account")
    config.readEntry("Password", "")
  end

  def password=(password)
    config = @config.group("Account")
    config.writeEntry("Password", password)
    config.sync
  end

  def auto_login
    config = @config.group("Account")
    config.readEntry("AutoLogin", true)
  end

  def auto_login=(flag)
    config = @config.group("Account")
    config.writeEntry("AutoLogin", flag)
    config.sync
  end

  def default_name
    config = @config.group("Write")
    config.readEntry("DefaultName", "")
  end

  def default_name=(name)
    config = @config.group("Write")
    config.writeEntry("DefaultName", name)
    config.sync
  end

  def default_mail
    config = @config.group("Write")
    config.readEntry("DefaultMail", "")
  end

  def default_mail=(mail)
    config = @config.group("Write")
    config.writeEntry("DefaultMail", mail)
    config.sync
  end

  def kotehan
    config = @config.group("Write")
    config.readEntry("Kotehan", [])
  end

  def kotehan=(list)
    config = @config.group("Write")
    config.writeEntry("Kotehan", list)
    config.sync
  end

  def thread_font
    config = @config.group("Face")
    font_str = config.readEntry("ThreadFont", "")
    font = Qt::Font.new
    font.fromString(font_str)
    font
  end

  def thread_font=(font)
    config = @config.group("Face")
    config.writeEntry("ThreadFont", font.toString)
    config.sync
  end
end
