
#ifndef __THREADS_NATIVE__
#define __THREADS_NATIVE__

#include "vm/jni.h"
#include "vm/thread.h"

struct native_thread_lock {
  tOBREF                     object;    // The object which is locked
  struct native_thread_lock* next;
  pthread_t                  pthread;   // The id of the thread that 
                                        // acquired the lock
  pthread_mutex_t            mutex;     // The lock
  pthread_cond_t             cond;      // The condition object
  int                        iHasCondition; 
};

typedef struct native_thread_lock tThreadLock;

int THREAD_WaitForNativeThreads(JNIEnv* env);
tThreadNode* THREAD_FindThread();
tThreadNode* THREAD_FindThreadByID(threadId_t threadId);
tThreadNode* THREAD_FindThreadByObject(tOBREF pstObject);

#ifndef GARBAGE2
int THREAD_StopAllThreads();
int THREAD_WakeAllThreads();
#endif

int THREAD_free_lock(tOBREF pstObject);
int THREAD_FreeLocks();

int THREAD_addThreadToList(tStackFrame* pstFrame, void* pthread, 
			   tOBREF obj, void* stackBottom);
int THREAD_GetNumberThreads();
void THREAD_InitMainThread(tOBREF hThread,  
			   /* @parm Thread to initialise */
			   int iPriority, 
			   /* @parm Priority to set thread to */
			   tStackFrame* pstFrame,  
			   /* @parm Environment frame to give to thread */
			   tJNIData* pstJNIData, 
			   /* A JNIData structure that has been created 
			      by __createJNIData */
			   void* stackBottom 
			   /* An optional argument indicating where the 
			      start of the C stack is */
			   );
#endif
