#include "config.h"

#ifdef KISSME_LINUX_USER

#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>
#include <time.h>
#include <sys/time.h>
#include <signal.h>
#include <errno.h>

#include "vm/wrappers.h"
#include "vm/garbage.h"
#include "vm/garbage2.h"
#include "vm/jni_data.h"


#ifndef ALTERNATE_CONDITION

int pthread_mutexattr_setkind_np (pthread_mutexattr_t* attr, int type);

int sys_mutex_provider_init()
{
  /* Do nothing */
  return 0;
}

/* Create a new system mutex object 
* 
* Currently ignores the type
*
*/

tMutex* sys_mutex_create(int type)
{
  pthread_mutex_t* ret = 
    (pthread_mutex_t*) sys_malloc(sizeof(pthread_mutex_t));
  
  if (type) {//recursive
    pthread_mutexattr_t kind;
    
    pthread_mutexattr_init (&kind);
    pthread_mutexattr_setkind_np(&kind, PTHREAD_MUTEX_RECURSIVE_NP);
    pthread_mutex_init(ret, &kind);
  }
  else {
    pthread_mutex_init(ret, NULL);
  }
  return ret;
}

/* Destroy a system mutex object */

int sys_mutex_destroy(tMutex* mutex)
{
  sys_free(mutex);
  /* also not impl */
  return 0;
}

/* Lock a mutex object 
 */
int sys_mutex_lock(tMutex* mutex)
{
  pthread_mutex_lock((pthread_mutex_t*) mutex);
  return 0;
}


/* Unlock a mutex object 
 */
int sys_mutex_unlock(tMutex* mutex)
{
 pthread_mutex_unlock((pthread_mutex_t*) mutex);
 return 0;
}


//Condition variables
int sys_condition_provider_init()
{
  return 0;
}


tCondVariable* sys_condition_create()
{
  pthread_cond_t* ret = (pthread_cond_t*) sys_malloc(sizeof(pthread_cond_t));
  if (ret == NULL) {
    return ret;
  }
  pthread_cond_init(ret, NULL);
  return ret; 
}


tCondVariable* sys_condition_create_inplace(tCondVariable* cond)
{
  pthread_cond_init(cond, NULL);
  return cond;
}


int sys_condition_destroy(tCondVariable* cond)
{
#ifdef IN_PLACE_CONDITION
  if (cond) {
    sys_free(cond);
  }
#endif
  return 0;
}


int sys_condition_signal(tCondVariable* cond)
{
  pthread_cond_signal(cond);
  return 0;
}


int sys_condition_broadcast(tCondVariable* cond)
{
  pthread_cond_broadcast(cond);
  return 0;
}

/*
 * Wait indefinitely on a condition variable, blocking GC
 */
int sys_condition_wait_nogc(tCondVariable* cond, tMutex* mutex)
{
  return pthread_cond_wait(cond, mutex);
}


/*
 * Wait indefinitely on a condition variable, allowing GC
 */
int sys_condition_wait(tCondVariable* cond, tMutex* mutex)
{
  int rc;
  tAllocatorHeap* pstHeap = JNI_getCurrentHeap();
  
  assert(pstHeap);
  GARBAGE_EnterGCRegion(pstHeap, sys_current_thread());
  rc = pthread_cond_wait(cond, mutex);
  GARBAGE_ExitGCRegion(pstHeap, sys_current_thread());

  return rc;
}


/*
 * Wait on a condition variable with a timeout, blocking GC
 */
int sys_condition_timedwait_nogc(tCondVariable* cond, tMutex* mutex, 
				 tTimeSpec* spec)
{
  return pthread_cond_timedwait(cond, mutex, spec);
}


/*
 * Wait on a condition variable with a timeout, allowing GC
 */
int sys_condition_timedwait(tCondVariable* cond, tMutex* mutex, 
			    tTimeSpec* spec)
{
  int rc;
  tAllocatorHeap* pstHeap = JNI_getCurrentHeap();
  
  assert(pstHeap);
  GARBAGE_EnterGCRegion(pstHeap, sys_current_thread());
  rc = pthread_cond_timedwait(cond, mutex, spec);
  GARBAGE_ExitGCRegion(pstHeap, sys_current_thread());

  return rc;
}
#endif 
#endif
