#ifndef __STRUCT_TOBJECT_H__
#define __STRUCT_TOBJECT_H__

/* struct for objects ******************************************************/

/*
 * @doc TYPE
 * @struct
 * This structure contains all the data necessary for representing and
 * using Java objects.
 *
 */

/* Note: we should try remove the hHandle member, that info should somehow be tracked in the handle table 
 *
 * The pi32Vars member could be removed if the whole object is allocated in one block
 */

#include "vm/wrappers.h"

struct tobject
{
#ifdef GARBAGE
  /* this must always be the first field of this structure */
  int32   i32Flags;    /* @field Used for type and marking in garbage collection */
#endif
#ifdef DEBUG_OBJECT_FOR_GC
  int32 magic1;
#endif
#ifdef IBM_LOCKS
 int32 lock_word;
#endif
#ifdef PERSIST
#ifndef REVRPOT
  PID    pid;
#endif
#endif
  tCondVariable* condVariable;
#ifdef IN_PLACE_CONDITION
  tCondVariable actualCondVariable;
#endif
  struct tobject** hHandle; /* @field Pointer to this object's handle so that it can be updated if it moves */
  /* Changed to be a tuple pointer */
  tClassLoaderTuple* pstType;     /* @field Pointer to the class that this object is an instance of */
  
#ifdef DEBUG_OBJECT_FOR_GC
  int32 magic2;
#endif
  int32* pi32Vars;     /* @field Pointer to memory for instance variables */
};

#endif
