/*
 * store.h
 *
 * Definitions for store.
 *
 */

#ifndef __STORE_H__
#define __STORE_H__

#include "vm/stdtypes.h"

typedef int32 PID;  // FIXME ...


/* functions for opening and closing stores */

int STORE_OpenStore (const char* storename);
int STORE_NewStore (const char* storename);
void STORE_CloseStore (void);

/* functions for getting and setting the root object's PID */

PID STORE_GetRootPID(void);
void STORE_SetRootPID(PID pid);

/* functions for manipulating objects within a store */

int STORE_GetObjectSize (PID pid);
void STORE_LoadObject (PID pid, char* obj);
void STORE_UpdateObject (PID pid, void* obj);
PID STORE_NewObject (int objsize);

#endif




