#include <config.h>
#include <stdio.h>


//See llist.h
#include "vm/llist.h"

tList* LLIST_Create_List()
{
    tList* newlist = (tList*) sys_malloc( sizeof(tList));
    assert(newlist);
    newlist->head = NULL;
    newlist->count =0;
#ifdef DEBUG_TRACE
    eprintf("<1>Created list %p\n", newlist);
#endif
    return newlist;
}

int LLIST_Size(tList* thelist)
{
 return thelist->count;
}

int LLIST_DestroyList(tList* thelist)
{
    tListNode *iter, *next;
    if(thelist->count)
	{
	    iter = next = thelist->head;
	    while(next != NULL)
		{
		    next = iter->next;
		    sys_free(iter);
    		    iter = next;
		}
	}
    sys_free(thelist);
    return 0;
}

int LLIST_AddAtTail(tList* thelist, void* npayload)
{
    tListNode* newNode;
    assert(thelist != NULL);
    newNode = (tListNode*) sys_malloc( sizeof( tListNode ));
    assert(newNode);

    if(thelist->head == NULL)
	{
	    thelist->head = newNode;
	    newNode->next = NULL;
	}
    else
	{
	    tListNode *iter,*prev;
	    iter = prev = thelist->head;
	    while(iter != NULL)
		{
		    prev = iter;
		    iter = iter->next;
		}

	    //Now prev points to the tail
	    newNode->next = NULL;
	    prev->next = newNode;
	}
	    newNode->payload = npayload;

	    thelist->count++;
	    eprintf("<1>count is now %i\n", thelist->count);
	    return 1;
}

int LLIST_AddAtHead(tList* thelist, void* npayload)
{
    tListNode* newNode;
    assert(thelist != NULL);
    newNode = (tListNode*) sys_malloc( sizeof( tListNode ));
    assert(newNode);

    if(thelist->head == NULL)
	{
	    thelist->head = newNode;
	    newNode->next = NULL;
	}
    else
	{
	    newNode->next = thelist->head;
	    thelist->head = newNode;
	}

	    newNode->payload = npayload;
	    thelist->count++;

	    return 0;
}

void* LLIST_ElementAt(tList* thelist, int index)
{
  int count = index;
  tListNode* iter = thelist->head;
  while((iter != NULL) && (count > 0))
    {
      iter = iter->next;
      count--;
    }
  if(iter)
    return iter->payload;
  return NULL;
}

tListIterator* LLIST_FindFirst(tList* thelist)
{
    tListIterator* newIterator = (tListIterator*) sys_malloc(sizeof(tListIterator));
    tListNode* listNode;
    assert(newIterator);

    listNode = (tListNode*) sys_malloc(sizeof(tListNode));
    assert(listNode);
    listNode->payload = thelist->head->payload;
    listNode->next = thelist->head->next;
    newIterator->entry = listNode;
    return newIterator;
}

tListIterator* LLIST_FindNext(tList* thelist, tListIterator* iterator)
{
  if(iterator->entry == NULL)
    return NULL;

    if(iterator->entry->next)
	{
	    iterator->entry = iterator->entry->next;
	    return iterator;
    }
    else
	return NULL;

}

int LLIST_Remove(tList* thelist, void* npayload)
{
    tListNode *prev, *iter;
    assert(thelist != NULL);

    prev = iter = thelist->head;
    while(iter != NULL)
	{
	    if(npayload == iter->payload)
		{
		    //Remove this one
		    if(iter == thelist->head)
			{
			    //Special case
			    thelist->head = iter->next;
			    sys_free(iter);
			}
		    else
			{
			    prev->next = iter->next;
			    sys_free(iter);
			}
		    thelist->count--;
		    return 0;
		    break;
		}
	    iter = iter->next;
	}
    return 1;
}

int LLIST_RemoveAt(tList* thelist, int index)
{
  int count = index;
  tListNode* iter = thelist->head;
  tListNode* prev;
  prev = iter;

  if(index == 0)
    {
      //Remove from head
      thelist->head = thelist->head->next;
      thelist->count--;
      sys_free(iter);
      return 0;
    }
  while((iter != NULL) && (count > 0))
    {
      prev = iter;
      iter = iter->next;
      count--;
    }
  if(iter)
    {
      prev->next = iter->next;
      sys_free(iter);
      thelist->count--;
      return 0;
    }
  return -1;
}




