/*
 * Copyright (C) 2002, Stephen Crawley
 *
 * This file is part of the kissme/teaseme project, which in turn is part of the JOS project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * The Kissme Native Interface provides Kissme-specific extensions
 * to the JNI.
 */

#ifndef __KISSME_KNI_H__
#define __KISSME_KNI_H__

#include "config.h"

#include "vm/jni.h"

#define KNI_VERSION_1_0 0x7f010000 /* KNI version 1.0 */


typedef tAllocatorHeap* jheap;

struct KissmeNativeInterface
{
  _Jv_func reserved0;
  _Jv_func reserved1;
  _Jv_func reserved2;

  jint    (JNICALL *GetKNIVersion)       (JNIEnv *);
  jheap   (JNICALL *GetHeap)             (JNIEnv *);
  jobject (JNICALL *SwizzleObjectField)  (JNIEnv *, jobject, jfieldID); 
  jobject (JNICALL *SwizzleArrayElement) (JNIEnv *, jobjectArray, jint); 
  void 	  (JNICALL *MarkUpdated) 	 (JNIEnv *, jobject); 
  void	  (JNICALL *MarkRefsUpdated)	 (JNIEnv *, jobject); 
  void 	  (JNICALL *EnterGCPoint)	 (JNIEnv *); 
  void	  (JNICALL *EnterGCRegion)       (JNIEnv *); 
  void	  (JNICALL *ExitGCRegion)	 (JNIEnv *);
};


typedef struct KissmeNativeInterface KNIApi;

#endif /* __KISSME_KNI_H__ */
