/*
 * Copyright (C) 2001, John Leuner.
 *
 * This file is part of the kissme/teaseme project, which in turn is part of the JOS project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * @doc MODULE
 * @module jni.h |
 *
 * This file contains the declarations for tJNIData and the Kissme
 * internal JNI APIs.
 */

#ifndef __KISSME_JNI_DATA_H__
#define __KISSME_JNI_DATA_H__

#include "config.h"

#include "vm/jni.h"

/*
 * threadId_t values are small identifiers (23 bits or less) for native
 * threads / Java threads.  They are used in 'thin locks'; see vm/lock.c
 */ 
typedef short threadId_t;

/*
 * @doc STRUCT
 * @struct tJNIData |
 * This structure stores data for JNI calls.  There is one of these
 * for each Java thread / native thread.
 */

typedef struct tjnidata
{
  JNIEnv          functions;           /* @field Pointer to the 
					  JNINativeInterface structure */
  jobject         pstException;        /* @field Pointer to an exception 
					  if one has is being thrown */
  uint16          u16NumLocalRefs;     /* @field Number of local references 
					  for current call */
  uint16          u16NumLocalRefsUsed; /* @field Number of local references 
					  that have been used */
  jobject*        ppstLocalRefs;       /* @field Pointer to array of local 
					  references for current call */
  tStackFrame*    pstTopFrame;         /* @field Top stack frame before 
					  native call */
  tAllocatorHeap* pstHeap;             /* @field The heap associated with 
					  this JOSProcess */
  pthread_t       pthread;             /* @field The Java thread's native
					  thread identifier */
  threadId_t      threadId;            /* @field The corresponding threadId:
					  used in thin locks */
} tJNIData;

extern uint16 JNI_u16NumGlobalRefs;
extern uint16 JNI_u16NumGlobalRefsUsed;
extern jobject* JNI_ppstGlobalRefs;
extern JNIEnv JNI_pstFunctionTable;

void JNI_zeroJNITable();
void JNI_Init(JNIEnv* env);
void JNI_Finish(void);
int JNI_CallNativeMethod(tStackFrame*, jmethodID);
tJNIData* JNI_getJNIData(pthread_t threadId);
tJNIData* JNI_getJNIDataOrNull(pthread_t threadId);
tAllocatorHeap* JNI_getCurrentHeap();
JNIEnv* JNI_getJNIEnvPtr();
void JNI_setJNIData(tJNIData* data, pthread_t threadId);

typedef struct HASH_tsthashsearch JNI_JNIDataIterator;
tJNIData* JNI_firstJNIData(JNI_JNIDataIterator* iter);
tJNIData* JNI_nextJNIData(JNI_JNIDataIterator* iter);

void JNI_CreateLocalRef(tJNIData* pstJNIData, jobject obj);
void JNI_ReserveLocalRefs(tJNIData* pstJNIData, uint16 nosRefs);

#ifdef PERSIST
#include "vm/rpot.h"
#endif

//Variables for dynamic linking

#ifdef DLOPEN

extern int JNI_NumberLoadedLibraries;
extern void* JNI_DynLoadedLibraries[20];

#endif

#endif
