/*
 * Copyright (C) 2003, Stephen Crawley.
 *
 * This file is part of the kissme/teaseme project, which in turn is part of the JOS project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Java Invocation API.  Note: we currently only implement enough to allow
 * GetEnv to be used.
 */

#ifndef __INVOCATION_H__
#define __INVOCATION_H__

#include "vm/jni.h"

typedef struct JavaVMData {
  JavaVM          functions;
} JavaVMData;


/* Get the default JavaVM object */
JavaVM *INVOC_GetJavaVM();

/* Implementations for the default JavaVM object */
jint INVOC_DestroyJavaVM(JavaVM *);
jint INVOC_AttachCurrentThread(JavaVM *, void **, void *);
jint INVOC_DetachCurrentThread(JavaVM *);
jint INVOC_GetEnv(JavaVM *, void **, jint);
jint INVOC_AttachCurrentThreadAsDaemon(JavaVM *, void **, void *);


#endif

