#ifndef __INTERP_METHODS_H__
#define __INTERP_METHODS_H__

#include "vm/interp.h"


/* function prototypes *****************************************************/

int INTERP_CheckCast(JNIEnv* env, tClassLoaderTuple*, tClassLoaderTuple*);
tOBREF INTERP_Interpret(JNIEnv* env, void* arg1, int arg2);

tOBREF INTERP_RunNonVirtualMethod(JNIEnv* env, tClassLoaderTuple*, 
				  char* classname, char* methodname,
				  char* methodsig, int32* ArgumentStack);
tOBREF INTERP_RunNonVirtualMethodFromPtr(JNIEnv* env, tMethod* pstMethod,
					 int32* pi32Args);
tOBREF INTERP_RunNonVirtualMethodFromPtr_with_native_stack(JNIEnv* env,
							   tMethod* pstMethod, 
							   int32* pi32Args);


tOBREF INTERP_RunVirtualMethod(JNIEnv* env, tClassLoaderTuple*, 
			       char* classname, char* methodname,
			       char* methodsig, int32* ArgumentStack);
tOBREF INTERP_RunVirtualMethodFromPtr(JNIEnv* env, tMethod* pstMethod, 
				      int32* pi32Args);
tOBREF INTERP_RunVirtualMethodFromPtr_with_native_stack(JNIEnv* env,
							tMethod* pstMethod,
							int32* pi32Args);

tOBREF INTERP_RunSpecialMethodFromPtr(JNIEnv* env, tMethod* pstTheMethod,
				      int32*  pi32Args);
tOBREF INTERP_RunSpecialMethodFromPtr_with_native_stack(JNIEnv* env,
							tMethod* pstTheMethod,
							int32*   pi32Args);

tOBREF INTERP_RunStaticMethod(JNIEnv* env, tClassLoaderTuple*, char* classname,
			      char* methodname, char* methodsig, 
			      int32* ArgumentStack);
tOBREF INTERP_RunStaticMethodFromPtr(JNIEnv* env, tMethod* pstMethod, 
				     int32* pi32Args);
tOBREF INTERP_RunStaticMethodFromPtr_with_native_stack(JNIEnv* env, 
						       tMethod* pstMethod, 
						       int32* pi32Args);


tStackFrame* CatchExternalException(JNIEnv* env,tStackFrame* pstOldFrame,
				    tOBREF pstExOb);
tStackFrame* CatchException(JNIEnv* env, tStackFrame* pstOldFrame);
tStackFrame* CatchExceptionHelper(JNIEnv* env, tStackFrame* pstOldFrame,
				  tOBREF pstExOb);


tStackFrame* ThrowNamedExceptionWithMessage(JNIEnv* env,
					    tStackFrame* pstOldFrame, 
					    char* pszExName, char* message);
tOBREF INTERP_ExceptionObjectFromNameAndMessage(JNIEnv* env, char* pszExName,
						char* message);
tStackFrame* ThrowNamedException(JNIEnv* env, tStackFrame* pstOldFrame,
				 char* pszExName);


tStackFrame* ThrowOutOfMemory(JNIEnv* env, tStackFrame* pstOldFrame);
tStackFrame* ThrowNullPointer(JNIEnv* env, tStackFrame* pstOldFrame);
tStackFrame* ThrowClassNotFound(JNIEnv* env, tStackFrame* pstOldFrame);
tStackFrame* ThrowNegativeArraySize(JNIEnv* env, tStackFrame* pstOldFrame);
tStackFrame* ThrowArrayIndex(JNIEnv* env, tStackFrame* pstOldFrame, int32);
tStackFrame* ThrowClassCast(JNIEnv* env, tStackFrame* pstOldFrame,
			    char *fromName, char *toName);
tStackFrame* ThrowArithmetic(JNIEnv* env, tStackFrame* pstOldFrame);
tStackFrame* ThrowRuntimeException(JNIEnv* env, tStackFrame* pstOldFrame);
tStackFrame* ThrowInternalError(JNIEnv* env, tStackFrame* pstOldFrame,
				char *message);
tStackFrame* ThrowNoClassDefError(JNIEnv* env, tStackFrame* pstOldFrame,
				  char *message);
tStackFrame* ThrowNoSuchMethodError(JNIEnv* env, tStackFrame* pstOldFrame,
				    char *message);
tStackFrame* ThrowNoSuchFieldError(JNIEnv* env, tStackFrame* pstOldFrame,
				   char *message);
tStackFrame* ThrowClassChangeError(JNIEnv* env, tStackFrame* pstOldFrame,
				   char *format, ...);


int INTERP_FigureOutLineNumber(tStackFrame* pstFrame);
void INTERP_printStackTrace(JNIEnv* env, tOBREF exceptionObject);

#ifdef DEBUG_FRAME_FOR_GC
void INTERP_CheckStackFrame(tStackFrame* pstFrame);
#endif

int shutdown_machine(tOBREF pstExOb, int forced_shutdown, int retval);

int isJavaFloatNaN(float num);
int isJavaDoubleNaN(double num);


#ifdef PRELOAD
/*
 * @globalv
 * This is a pointer to memory used for static class fields when preloaded
 * classes are being used.
 *
 */
extern int32* INTERP_pi32GlobalStatVars;
extern tOBREF* INTERP_ppstGlobalClassObjects;
extern InternalNativeMethod* INTERP_pstGlobalNativeMethods;
extern byte* INTERP_pbGlobalInitialised;
#endif

#ifdef GARBAGE
extern int32* INTERP_pi32MainStack;
extern tStackFrame** INTERP_ppstCurrFrame;
#endif

#ifdef DEBUG_TRACE
/* 
 * This method sets / unsets the trace flags.
 */
void INTERP_SetTraceFlags(int showLocals, int showOpStack, int showOpCodes);
#endif

tOBREF Interpret(JNIEnv* env, tStackFrame* pstInitFrame, int iMultiThread);

tOBREF INTERP_ConstructMainThread(JNIEnv* env);


#ifdef DEBUG_TRACE
//static void StackInspect(tStackFrame*, int32*);
#endif


#define SAVEENV() { pstCurrFrame->pbPC = pbPC; \
		    pstCurrFrame->pi32OpTop = optop; \
		  }

#define LOADENV() { pbPC = pstCurrFrame->pbPC; \
		    optop = pstCurrFrame->pi32OpTop; \
		    pi32Vars = pstCurrFrame->pi32Vars; \
                    pstCurrClass = pstCurrFrame->pstCurrClass; \
		  }
#endif
