#ifdef not_def
{
  {
    {
#endif
    case getstatic:
      {
	int16 i16Temp;
        uint16 u16Offset;
	Uid uidSig;
	
	tClassLoaderTuple*       pstTempClass;
	tField* pstTempField;
	// We form an index into the this class's constant pool
	
	i16Temp = (*pbPC++) * 256;
	i16Temp += (*pbPC++);
	
#ifdef DEBUG
	assert(CONSTTAG(pstCurrClass->pstClass, i16Temp) == CONSTANT_Fieldref);
#endif
	
	pstTempField = CONSTGET_StatField(env, pstCurrClass, i16Temp);
	if (pstTempField == NULL) {
	  SAVEENV();
	  pstCurrFrame = 
	    ThrowNoSuchFieldError(env, pstCurrFrame, 
				  "cannot find a static field for this class");
	  LOADENV();
	  break;
	}
	
	pstTempClass = pstTempField->pstClass;
	if (pstTempClass == NULL) {
	  SAVEENV();
	  pstCurrFrame = 
	    ThrowNoClassDefError(env, pstCurrFrame,
				 "cannot find static field's type");
	  LOADENV();
	  break;
	}

	if (pstTempClass->pstClass->bInitialised == 0) { // && (pstTempClass != pstClassType))
	  tOBREF pstExOb = 
	    INITIALIZE_InitializeClass(env, pstTempClass->classObject);
	  if (pstExOb) {
	    *optop = (int32) pstExOb;
	    SAVEENV();
	    pstCurrFrame = CatchException(env, pstCurrFrame);
	    LOADENV();
	    break;
	  }
	}
	
	uidSig = CONSTGET_UidFieldSig(env, pstCurrClass, i16Temp);
	u16Offset = CONSTGET_StatFieldOffset(env, pstCurrClass, i16Temp);
	switch (uidSig[0]) {
	  /* all 32 bits or less */
#if defined(PERSIST) && defined(STATICPERSIST)
	case 'L':
	case '[':
	  {
	    /* need to fault in the object */
	    optop++;
	    *optop = (int32) RPOT_PIDtoLA(pstTempClass->pi32StatVars[u16Offset]);
	    break;
	  }
#else
	case 'L':
	case '[':
#endif
	case 'B':
	case 'C':
	case 'F':
	case 'I':
	case 'S':
	case 'Z':
	  {
#ifdef RESURRECT_QUICK
	    //            pbPC[-3] = getstatic_quick;
#endif
	    optop++;
	    *optop = pstTempClass->pi32StatVars[u16Offset];
	    break;
	  }
	  /* 64 bits - put in consecutive stores */
	case 'D':
	case 'J':
	  {
#ifdef RESURRECT_QUICK
	    //            pbPC[-3] = getstatic2_quick;
#endif
	    
	    optop += 2;
	    *(optop - 1) = pstTempClass->pi32StatVars[u16Offset];
	    *optop = pstTempClass->pi32StatVars[u16Offset + 1];
	      break;
	    }
	  
	default:
	    {
	      panic("Interpreter error in getstatic instruction. pbPC = %u",
		    pbPC - 3 - pstCurrFrame->pbCode);
	    }
	  }
	break;
      }
      
#ifdef RESURRECT_QUICK
    case getstatic_quick:
      {
	int16 i16Temp;
	
	i16Temp = (*pbPC++) * 256;
	i16Temp += (*pbPC++);
	
	optop++;
	*optop = 
	  *(((tField*) CONSTGET(pstCurrClass->pstClass, i16Temp))->pi32Addr);
	break;
      }
      
    case getstatic2_quick:
      {
	int16 i16Temp;
	
	i16Temp = (*pbPC++) * 256;
	i16Temp += (*pbPC++);
	
	optop += 2;
	*(optop - 1) = 
	  *(((tField*) CONSTGET(pstCurrClass->pstClass, i16Temp))->pi32Addr);
	*optop = 
	  *(((tField*) (CONSTGET(pstCurrClass->pstClass, 
				 i16Temp)))->pi32Addr + 1);
	break;
      }
#endif /* RESUURECT_QUICK */
      
    case putstatic:
      {
	int16 i16Temp;
        uint16 u16Offset;
	Uid uidSig;
	tClassLoaderTuple* pstTempClass;
	tField* pstTempField;
	
	i16Temp = (*pbPC++) * 256;
	i16Temp += (*pbPC++);
	
#ifdef DEBUG
	assert(CONSTTAG(pstCurrClass->pstClass, i16Temp) == CONSTANT_Fieldref);
#endif
	pstTempField = CONSTGET_StatField(env, pstCurrClass, i16Temp);
	if (pstTempField == NULL) {
	  SAVEENV();
	  pstCurrFrame = 
	    ThrowNoClassDefError(env, pstCurrFrame, 
				 "cannot find a static field of this class");
	  LOADENV();
	  break;
	}
	pstTempClass = pstTempField->pstClass;
	if (pstTempClass == NULL) {
	  SAVEENV();
	  pstCurrFrame = 
	    ThrowNoClassDefError(env, pstCurrFrame,
				 "cannot find static field's type");
	  LOADENV();
	  break;
	}
	
	if (pstTempClass->pstClass->bInitialised == 0) { // && (pstTempClass != pstClassType))
	  tOBREF pstExOb = 
	    INITIALIZE_InitializeClass(env, pstTempClass->classObject);
	  if (pstExOb) {
	    *optop = (int32) pstExOb;
	    SAVEENV();
	    pstCurrFrame = CatchException(env, pstCurrFrame);
	    LOADENV();
	    break;
	  }
	}

	/* asssume that the signature has just one important letter */
	uidSig = CONSTGET_UidFieldSig(env, pstCurrClass, i16Temp);
	u16Offset = CONSTGET_StatFieldOffset(env,pstCurrClass, i16Temp);
	switch (uidSig[0]) {
	  /* all 32 bits or less */
#if defined(PERSIST) && defined(STATICPERSIST)
	case 'L':
	case '[':
	  {
	    /* need to deswizzle the pointer */
	    pstTempClass->pi32StatVars[u16Offset] = 
	      RPOT_LAtoPID((void*) *optop);
	    optop--;
	    break;
	  }
#else
	case 'L':
	case '[':
#endif
	case 'B':
	case 'C':
	case 'F':
	case 'I':
	case 'S':
	case 'Z':
	  {
#ifdef QUICK
	    pbPC[-3] = putstatic_quick;
#endif
	    
	    pstTempClass->pi32StatVars[u16Offset] = *optop;
	    optop--;
	    break;
	  }
	  /* 64 bits - put in consecutive stores */
	case 'D':
	case 'J':
	  {
#ifdef QUICK
	    pbPC[-3] = putstatic2_quick;
#endif
	    
	    pstTempClass->pi32StatVars[u16Offset] = *(optop - 1);
	    pstTempClass->pi32StatVars[u16Offset + 1] = *optop;
	    optop -= 2;
	    break;
	  }
	default:
	  {
	    panic("Interpreter error in putstatic instr. pbPC = %u in %s.%s%s", 
		  pbPC - 3 - pstCurrFrame->pbCode, 
		  pstCurrFrame->pstCurrClass->uidName, 
		  pstCurrFrame->pstCurrMethod->uidName, 
		  pstCurrFrame->pstCurrMethod->uidSignature);
	  }
	}
        break;
      }
      
#ifdef QUICK
    case putstatic_quick:
      {
	int16 i16Temp;
	
	i16Temp = (*pbPC++) * 256;
	i16Temp += (*pbPC++);
	
	*(((tField*) CONSTGET(env, pstCurrClass, i16Temp))->pi32Addr) = *optop;
	optop--;
	break;
      }

    case putstatic2_quick:
      {
	int16 i16Temp;

	i16Temp = (*pbPC++) * 256;
	i16Temp += (*pbPC++);

	*(((tField*) CONSTGET(env, pstCurrClass, i16Temp))->pi32Addr) =
	  *(optop - 1);
	*(((tField*) CONSTGET(env, pstCurrClass, i16Temp))->pi32Addr + 1) =
	  *optop;
	optop -= 2;
	break;
      }
#endif /* QUICK */

    case getfield:
      {
	int16 i16Temp;
	uint16 u16Offset;
	Uid uidBytes;
	
	i16Temp = (*pbPC++) * 256;
	i16Temp += (*pbPC++);
	
#ifdef DEBUG
	assert(CONSTTAG(pstCurrClass->pstClass, i16Temp) == CONSTANT_Fieldref);
#endif
	
        /* signature tells us how big field is */
	uidBytes = CONSTGET_UidFieldSig(env,pstCurrClass, i16Temp);
	u16Offset = CONSTGET_InstFieldOffset(env, pstCurrClass, i16Temp);
        switch (uidBytes[0]) {
	  /* all 32 bits or less */
#ifdef PERSIST
	case 'L':
	case '[':
	  {
#ifdef EAGERINDIRECT
	    assert(*optop != NULL);
	    *optop = DEREF((tOBREF) *optop)-> pi32Vars[u16Offset];
#else
	    if (*optop == 0) {
	      SAVEENV();
	      pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	      LOADENV();
	      break;
	    }
	    
#ifndef GARBAGE_GENERATIONAL
	    if (ISPID(DEREF((tOBREF) *optop)->pi32Vars[u16Offset])) {
	      /* need to fault in the object */
#ifdef NOSWIZZLE
	      *optop = (int32) RPOT_FaultObject(DEREF((tOBREF) *optop)->
						pi32Vars[u16Offset]);
#else
	      DEREF((tOBREF) *optop)->pi32Vars[u16Offset] =
		(int32) RPOT_FaultObject(DEREF((tOBREF) *optop)->
					 pi32Vars[u16Offset]);
	      *optop = DEREF((tOBREF) *optop)->pi32Vars[u16Offset];
#endif //NOSWIZZLE
	    }
	    else {
#endif //GARBAGE_GEN
	      *optop = DEREF((tOBREF) *optop)->pi32Vars[u16Offset];
#ifndef GARBAGE_GENERATIONAL
	    }
#endif
#endif //IF_EAGER
	    break;
	  }
#else //IF PERSIST
	case 'L':
	case '[':
#endif
	case 'B':
	case 'C':
	case 'F':
	case 'I':
	case 'S':
	case 'Z':
	  {
#ifdef RESURRECT_QUICK
	    
	    /* replace the getfield with getfield_quick */
	    pbPC[-3] = getfield_quick;
	    /* replace the first operand byte by the offset */
	    pbPC[-2] = u16Offset;
	    
#endif /* RESURRECT_QUICK */
	    
	    if (*optop) {
	      *optop = DEREF((tOBREF) *optop)-> pi32Vars[u16Offset];
	    }
	    else {
	      SAVEENV();
	      pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	      LOADENV();
	    }
	    break;
	  }
	  /* 64 bits - put in consecutive stores */
	case 'D':
	case 'J':
	  {
#ifdef RESURRECT_QUICK
	    /* replace the getfield with getfield_quick */
	    pbPC[-3] = getfield2_quick;
	    /* replace the first operand byte by the offset */
	    pbPC[-2] = u16Offset;
#endif /* RESURRECT_QUICK */
	    
	    optop++;
	    if (*(optop - 1)) {
	      /* do low byte first to preserve the object handle
		 which is at (optop - 1) */
	      
	      *optop = DEREF((tOBREF) *(optop - 1))->pi32Vars[u16Offset + 1];
	      *(optop - 1) = DEREF((tOBREF) *(optop - 1))->pi32Vars[u16Offset];
	    }
	    else {
	      SAVEENV();
	      pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	      LOADENV();
	    }
	    break;
	  }
          
	default:
	  {
	    panic("Interpreter error in getfield instr. pbPC = %u in %s.%s%s",
		  pbPC - 3 - pstCurrFrame->pbCode, 
		  pstCurrFrame->pstCurrClass->uidName,
		  pstCurrFrame->pstCurrMethod->uidName,
		  pstCurrFrame->pstCurrMethod->uidSignature);
	  }
	}
        break;
      }
      
#ifdef RESURRECT_QUICK
    case getfield_quick:
      {
	int32 i32Temp;
	
	/* XXX if this is >= 128 then all hell will break loose -
           (signed filling)*/
	i32Temp = (*pbPC++);

	pbPC++;
	
	if (*optop) {
	  //Jewel September
	  *optop = (DEREF((tOBREF) *optop))->pi32Vars[i32Temp];
	}
	else {
	  SAVEENV();
	  pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	  LOADENV();
	}
	break;
      }
      
    case getfield2_quick:
      {
	int32 i32Temp;
	
	/* XXX if this is >= 128 then all hell will break loose -
           (signed filling)*/
	i32Temp = (*pbPC++);
	pbPC++;
	
        optop++;
        if (*(optop - 1)) {
	  /* do low word first to preserve the object handle which is
             at (optop - 1) */
	  //Jewel sep
	  *optop = (DEREF((tOBREF) *(optop - 1)))->pi32Vars[i32Temp + 1];
	  *(optop - 1) = (DEREF((tOBREF) *(optop - 1)))->pi32Vars[i32Temp];
	}
        else {
	  SAVEENV();
	  pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	  LOADENV();
	}
        break;
      }
#endif /* RES_QUICK */
      
    case putfield:
      {
	int16 i16Temp;
	uint16 u16Offset;
        Uid uidBytes;
	
	i16Temp = (*pbPC++) * 256;
	i16Temp += (*pbPC++);
	
#ifdef DEBUG
	assert(CONSTTAG(pstCurrClass->pstClass, i16Temp) == CONSTANT_Fieldref);
#endif

	/* the signature has just one important letter */
	uidBytes = CONSTGET_UidFieldSig(env,pstCurrClass, i16Temp);
	u16Offset = CONSTGET_InstFieldOffset(env, pstCurrClass, i16Temp);
        switch (uidBytes[0]) {
	  /* all 32 bits or less */
#ifdef PERSIST
	case 'L':
	case '[':
	  {
	    optop -= 2;
	    
	    if (*(optop + 1)) {
	      /* just assign as an LA */
	      DEREF((tOBREF) *(optop + 1))->pi32Vars[u16Offset] = *(optop + 2);
	      DEREF((tOBREF) *(optop + 1))->i32Flags |=
		(PERSIST_Dirty | PERSIST_RefsDirty);
#ifdef UPDATEBITS
	      ((tOBREF) *(optop + 1))->i32UpdateBits |= (1 << u16Offset);
#endif
	    }
	    else {
	      SAVEENV();
	      pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	      LOADENV();
	    }
	    break;
	  }
#else
	case 'L':
	case '[':
#endif
	case 'B':
	case 'C':
	case 'F':
	case 'I':
	case 'S':
	case 'Z':
	  {
#ifdef RESURRECT_QUICK
	    /* replace the putfield with putfield_quick */
	    // just while we test the sveta stuff
	    //	pbPC[-3] = putfield_quick;
	    /* replace the first operand byte by the offset */
	    // pbPC[-2] = u16Offset;
#endif /* RESURRECT_QUICK */
	    
	    optop -= 2;
	    if (*(optop + 1)) {
	      DEREF((tOBREF) *(optop + 1))->pi32Vars[u16Offset] = *(optop + 2);
#ifdef PERSIST
	      DEREF((tOBREF) *(optop + 1))->i32Flags |= PERSIST_Dirty;
#endif
	    }
	    else {
	      SAVEENV();
	      pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	      LOADENV();
	    }
	    break;
	  }
	  /* 64 bits - put in consecutive stores */
	case 'D':
	case 'J':
	  {
#ifdef RESURRECT_QUICK
	    /* replace the putfield with putfield_quick */
	    pbPC[-3] = putfield2_quick;
	    /* replace the first operand byte by the offset */
	    pbPC[-2] = u16Offset;
#endif /* RESURRECT_QUICK */
	    
	    optop -= 3;
	    if (*(optop + 1)) {
	      DEREF((tOBREF) *(optop + 1))->pi32Vars[u16Offset] = *(optop + 2);
	      DEREF((tOBREF) *(optop + 1))->pi32Vars[u16Offset + 1] =
		*(optop + 3);
#ifdef PERSIST
	      DEREF((tOBREF) *(optop + 1))->i32Flags |= PERSIST_Dirty;
#endif
	    }
	    else {
	      SAVEENV();
	      pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	      LOADENV();
	    }
	    break;
	  }
	  
	default:
	  {
	    panic("Interpreter error in putfield instr. pbPC = %u in %s.%s%s", 
		  pbPC - pstCurrFrame->pbCode,
		  pstCurrFrame->pstCurrClass->uidName, 
		  pstCurrFrame->pstCurrMethod->uidName, 
		  pstCurrFrame->pstCurrMethod->uidSignature);
	  }
	}
        break;
      }
      
#ifdef RESURRECT_QUICK
    case putfield_quick:
      {
	int32         i32Temp;
	
	/* XXX if this is >= 128 then all hell will break loose -
           (signed filling)*/
        i32Temp = (*pbPC++);
        pbPC++;

        optop -= 2;
        if (*(optop + 1)) {
	  //Jewel sep
	  (DEREF((tOBREF) *(optop + 1)))->pi32Vars[i32Temp] = *(optop + 2);
	}
        else {
	  SAVEENV();
	  pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	  LOADENV();
	}
        break;
      }
      
    case putfield2_quick:
      {
	int32 i32Temp;

        i32Temp = (*pbPC++);
        pbPC++;

        optop -= 3;
        if (*(optop + 1)) {
	  //Jewel sep
	  (DEREF((tOBREF) *(optop + 1)))->pi32Vars[i32Temp] = *(optop + 2);
	  (DEREF((tOBREF) *(optop + 1)))->pi32Vars[i32Temp + 1] = *(optop + 3);
	}
	else
	  {
	    SAVEENV();
	    pstCurrFrame = ThrowNullPointer(env, pstCurrFrame);
	    LOADENV();
	  }
	break;
      }
#endif /* RESURRECT_QUICK */

      
