#ifdef not_def
{
  {
    {
#endif
    case lcmp:
      {
	long long op1, op2;
	
	op1 = *((long long*) (optop - 3));
	op2 = *((long long*) (optop - 1));
	
	optop -= 3;
	
	if (op1 < op2) {
	  *optop = -1;
	}
	else if(op1 > op2) {
	  *optop = 1;
	}
	else {
	  *optop = 0;
	}
        break;
      }
      
    case fcmpl: 
      { 
	float op1, op2;

	op1 = *((float *) (optop - 1));
	op2 = *((float *) (optop));

#ifdef DEBUG_FLOAT
	eprintf("fcmpl %12G %12G", op1, op2);
#endif
        optop--;
	if (isJavaFloatNaN(op1)) { //-1 on NaN
	  *optop = -1;
	}
	else if (isJavaFloatNaN(op2)) {
	  *optop = -1;
	}
	else {
	  if (op1 > op2) {
	    *optop = 1;
	  }
	  else if (op1 == op2) {
	    *optop = 0;
	  }
	  else {
	    *optop = -1;
	  }
	}
#ifdef DEBUG_FLOAT
	eprintf(" -> %i\n", *optop);
#endif
        break;
      }
      
    case fcmpg:
      {
	float op1, op2;

	op1 = *((float *) (optop - 1));
	op2 = *((float *) (optop));

#ifdef DEBUG_FLOAT
	eprintf("fcmpg %12G %f12G ", op1, op2);
#endif
        optop--;
	if (isJavaFloatNaN(op1)) { //+1 on NaN
	  *optop = 1;
	}
	else if (isJavaFloatNaN(op2)) {
	  *optop = 1;
	}
	else {
	  if (op1 > op2) {
	    *optop = 1;
	  }
	  else if (op1 == op2) {
	    *optop = 0;
	  }
	  else {
	    *optop = -1;
	  }
	}
#ifdef DEBUG_FLOAT
	eprintf("-> %i\n", *optop);
#endif
        break;
      }

    case dcmpl:
      {
	double op1, op2;
	op1 = *((double *) (optop - 3));
	op2 = *((double *) (optop - 1));

#ifdef DEBUG_FLOAT
	eprintf("dcmpl %12G %12G", op1, op2);
#endif
	optop -= 3;
	if (isJavaDoubleNaN(op1)) { //-1 on NaN
	  *optop = -1;
	}
	else if (isJavaDoubleNaN(op2)) {
	  *optop = -1;
	}
	else {
	  if (op1 > op2) {
	    *optop = 1;
	  }
	  else if (op1 < op2) {
	    *optop = -1;
	  }
	  else {
	    *optop = 0;
	  }
	}
#ifdef DEBUG_FLOAT
	eprintf(" -> %i\n", *optop);
#endif
	break;
      }

    case dcmpg:
      {
	double op1, op2;
	op1 = *((double *) (optop - 3));
	op2 = *((double *) (optop - 1));

#ifdef DEBUG_FLOAT
	eprintf("dcmpg %12G %12G", op1, op2);
#endif
	optop -= 3;
	if (isJavaDoubleNaN(op1)) { //NaN yields 1
	  *optop = 1;
	}
	else if (isJavaDoubleNaN(op2)) {
	  *optop = 1;
	}
	else {
	  if (op1 > op2) {
	    *optop = 1;
	  }
	  else if (op1 < op2) {
	    *optop = -1;
	  }
	  else {
	    //maybe we should explicitly check for the equal case first?
	    *optop = 0; 
	  }
	}
#ifdef DEBUG_FLOAT
	eprintf(" -> %i\n", *optop);
#endif
	break;
      }

      /* Branches */
      
    case ifeq:
      {
	int16 i16Temp;
	
	if (*(optop--) == 0) {
	  i16Temp = (*pbPC++) * 256;
	  i16Temp += (*pbPC++);
	  
#ifdef GARBAGE2
	  if (i16Temp < 0) {
	    GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap);
	  }
#endif
	  pbPC += (i16Temp - 3);
	}
	else {
          pbPC += 2;
        }
	break;
      }
      
    case ifne:
      {
	int16 i16Temp;
	
	if (*(optop--) != 0) {
	  i16Temp = (*pbPC++) * 256;
	  i16Temp += (*pbPC++);
#ifdef GARBAGE2
	  if (i16Temp < 0) {
	    GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap);
	  }
#endif
	  pbPC += (i16Temp - 3);
	}
	else
	  {
	    pbPC += 2;
	  }
	break;
      }
      
    case iflt:
      {
	int16 i16Temp;
	
	if (*(optop--) < 0) {
	  i16Temp = (*pbPC++) * 256;
	  i16Temp += (*pbPC++);
	  
#ifdef GARBAGE2
	  if (i16Temp < 0) {
	    GARBAGE_EnterGCPoint( pstCurrFrame->pstHeap, sys_current_thread());
	  }
#endif
	  
	  pbPC += (i16Temp - 3);
	}
	else {
	  pbPC += 2;
	}
	break;
      }
      
    case ifge:
      {
	int16 i16Temp;
	
	if (*(optop--) >= 0) {
	  i16Temp = (*pbPC++) * 256;
	  i16Temp += (*pbPC++);
	  
#ifdef GARBAGE2
	  if (i16Temp < 0) {
	    GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap);
	  }
#endif
	  
	  pbPC += (i16Temp - 3);
	}
	else {
	  pbPC += 2;
	}
	break;
      }
      
    case ifgt:
      {
	int16 i16Temp;
	
	if (*(optop--) > 0) {
	  i16Temp = (*pbPC++) * 256;
	  i16Temp += (*pbPC++);
	  
#ifdef GARBAGE2
	  if (i16Temp < 0) {
	    GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap);
	  }
#endif
	  
	  pbPC += (i16Temp - 3);
	}
	else
	  {
	    pbPC += 2;
	  }
	break;
      }
      
    case ifle:
      {
	int16 i16Temp;
	
	if (*(optop--) <= 0) {
	  i16Temp = (*pbPC++) * 256;
	  i16Temp += (*pbPC++);
	  
#ifdef GARBAGE2
	  if (i16Temp < 0) {
	    GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap);
	  }
#endif
	  
	  pbPC += (i16Temp - 3);
	}
	else {
	  pbPC += 2;
	}
	break;
      }
      
    case if_icmpeq:
      {
	int16 i16Temp;
	
	optop -= 2;
	if (*(optop + 1) == *(optop + 2)) {
	  i16Temp = (*pbPC++) * 256;
	  i16Temp += (*pbPC++);
	  
#ifdef GARBAGE2
	  if (i16Temp < 0) {
	    GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap);
	  }
#endif
	  pbPC += (i16Temp - 3);
	}
	else {
	  pbPC += 2;
	}
	break;
      }
      
    case if_icmpne:
      {
	int16 i16Temp;
	
	optop -= 2;
	if (*(optop + 1) != *(optop + 2)) {
	  i16Temp = (*pbPC++) * 256;
	  i16Temp += (*pbPC++);
#ifdef GARBAGE2
	  if (i16Temp < 0) {
	    GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap);
	  }
#endif
	  pbPC += (i16Temp - 3);
	}
	else {
	  pbPC += 2;
	}
	break;
      }
      
    case if_icmplt:
      {
	int16 i16Temp;
	
	optop -= 2;
	if (*(optop + 1) < *(optop + 2)) {
	  i16Temp = (*pbPC++) * 256;
	  i16Temp += (*pbPC++);
#ifdef GARBAGE2
	  if (i16Temp < 0) {
	    GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap);
	  }
#endif
	  pbPC += (i16Temp - 3);
	}
	else
	  {
	    pbPC += 2;
	  }
	break;
      }
      
    case if_icmpge:
      {
	int16 i16Temp;
	
	optop -= 2;
	if (*(optop + 1) >= *(optop + 2)) {
	  i16Temp = (*pbPC++) * 256;
	  i16Temp += (*pbPC++);
#ifdef GARBAGE2
	  if (i16Temp < 0) {
	    GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap);
	  }
#endif
	  pbPC += (i16Temp - 3);
	}
	else {
	  pbPC += 2;
	}
	break;
      }
      
    case if_icmpgt:
      {
	int16 i16Temp;
	
	optop -= 2;
	if (*(optop + 1) > *(optop + 2)) {
	  i16Temp = (*pbPC++) * 256;
	  i16Temp += (*pbPC++);
	  
#ifdef GARBAGE2
	  if (i16Temp < 0) {
	    GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap);
	  }
#endif
	  
	  pbPC += (i16Temp - 3);
	}
	else {
	  pbPC += 2;
	}
	break;
      }
      
    case if_icmple:
      {
	int16 i16Temp;
	
	optop -= 2;
	if (*(optop + 1) <= *(optop + 2)) {
	  i16Temp = (*pbPC++) * 256;
	  i16Temp += (*pbPC++);
#ifdef GARBAGE2
	  if (i16Temp < 0) {
	    GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap);
	  }
#endif
	  pbPC += (i16Temp - 3);
	}
	else {
	  pbPC += 2;
	}
	break;
      }
      
    case if_acmpeq:
      {
	int16 i16Temp;
	
	optop -= 2;
	if (*(optop + 1) == *(optop + 2)) {
	  i16Temp = (*pbPC++) * 256;
	  i16Temp += (*pbPC++);
#ifdef GARBAGE2
	  if (i16Temp < 0) {
	    GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap);
	  }
#endif
	  pbPC += (i16Temp - 3);
	}
	else {
	  pbPC += 2;
	}
	break;
      }
      
    case if_acmpne:
      {
	int16 i16Temp;
	
	optop -= 2;
	if (*(optop + 1) != *(optop + 2)) {
	  i16Temp = (*pbPC++) * 256;
	  i16Temp += (*pbPC++);
#ifdef GARBAGE2
	  if (i16Temp < 0) {
	    GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap);
	  }
#endif
	  pbPC += (i16Temp - 3);
	}
	else
	  {
	    pbPC += 2;
	  }
	break;
      }
      
    case goto_:
      {
	int16 i16Temp;
	
	i16Temp = (*pbPC++) * 256;
	i16Temp += (*pbPC++);
#ifdef GARBAGE2
	if (i16Temp < 0) {
	  GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap);
	}
#endif
	pbPC += (i16Temp - 3); /* need -3 to skip the instruction and args */
	break;
      }
      
    case jsr:
      {
	int16 i16Temp;
	
	i16Temp = (*pbPC++) * 256;
	i16Temp += (*pbPC++);
	*(++optop) = pbPC - pstCurrFrame->pbCode; /* XXX check this*/
#ifdef GARBAGE2
	if (i16Temp < 0) {
	  GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap);
	}
#endif
	pbPC += (i16Temp - 3);
	break;
      }
      
    case ret:
      {
	pbPC = pstCurrFrame->pbCode + pi32Vars[*pbPC];	/* XXX check this*/
	break;
      }
      
    case tableswitch:
      {
	int32 i32Temp;
	int32 i32DefaultOff;
	int32 i32Low;
	int32 i32High;
	byte* pbStartPC;
	
	/* remember PC at beginning of instruction */
	pbStartPC = pbPC - 1;
	
	while ((pbPC - pstCurrFrame->pbCode) % 4) {
	  pbPC++;
	}
	
	i32DefaultOff = (((int32)pbPC[0]) << 24) | (((int32)pbPC[1]) << 16) | 
	  (((int32)pbPC[2]) << 8) | pbPC[3];
	i32Low = (((int32)pbPC[4]) << 24) | (((int32)pbPC[5]) << 16) | 
	  (((int32)pbPC[6]) << 8) | pbPC[7];
	i32High = (((int32)pbPC[8]) << 24) | (((int32)pbPC[9]) << 16) | 
	  (((int32)pbPC[10]) << 8) | (pbPC[11]);
	pbPC += 12;
	
	/* check if outside switch range */
	if (*optop < i32Low || *optop > i32High) {
	  pbPC = pbStartPC + i32DefaultOff;
	  optop--;  //Jewel added this decrement 2/10/99
	}
	else {
	  /* skip to correct place for offset */
	  pbPC += (*optop - i32Low) * 4;
	  
	  /* read jump offset */
	  i32Temp = (((int32)pbPC[0]) << 24) | (((int32)pbPC[1]) << 16) |
	    (((int32)pbPC[2]) << 8) | (pbPC[3]);
	  
	  optop--;
	  pbPC = pbStartPC + i32Temp;
	}
	break;
      }
      
    case ifnull:       /* the new instruction 198 */
      {
	int16 i16Temp;
	
	if (*(optop--) == 0) {
	  i16Temp = (*pbPC++) * 256;
	  i16Temp += (*pbPC++);
#ifdef GARBAGE2
	  if (i16Temp < 0) {
	    GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap);
	  }
#endif
	  pbPC += (i16Temp - 3);
	}
	else {
	  pbPC += 2;
	}
	break;
      }
      
    case ifnonnull:
      {
	int16 i16Temp;
	
	if (*(optop--) != 0) {
	  i16Temp = (*pbPC++) * 256;
	  i16Temp += (*pbPC++);
#ifdef GARBAGE2
	  if (i16Temp < 0) {
	    GARBAGE_EnterGCPoint(pstCurrFrame->pstHeap);
	  }
#endif
	  pbPC += (i16Temp - 3);
	}
	else {
	  pbPC += 2;
	}
	break;
      }
      
