/*
 * Copyright (C) 2001, John Leuner.
 *
 * This file is part of the kissme/teaseme project, which in turn is part of the JOS project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * @doc MODULE
 * @module interp.h |
 *
 * This file includes definitions of the tObject structure for Java objects,
 * the tArray structure for Java arrays, the tStackFrame structure for the
 * call stack in the interpreter and the tAType enum for array types.  It
 * also includes prototypes of functions defined in interp.c that are used
 * elsewhere.
 *
 * The FLATSTACKSIZE #define is also here. It is used to define the size of
 * call stack super-frames.
 *
 */

#ifndef __INTERP_H__
#define __INTERP_H__

#ifndef DADDY_IS_WATCHING
#error Bad boy it seems config.h wasnt included
#endif


#include "vm/stdtypes.h"
#include "vm/classfil.h"


#define DOUBLE_NAN 0x7ff8000000000000L

#ifdef PERSIST
#include "vm/store.h"
#endif

//#define FLATSTACKSIZE 2048
#define ROUND32BIT(x) (((x) + 3) & ~3)

#ifdef PERSIST
/* these flags must not overlap with the GARBAGE flags */
#define PERSIST_Dirty       16L
#define PERSIST_RefsDirty   32L
/* mask for isolating all the update flags */
#define PERSIST_DirtyMask   48L

#ifdef EAGER
/* used in eager swizzling */
#define PERSIST_Swizzled    64L
#endif
#endif

/* macros for setting, clearing and checking object flags */
#define SETFLAG(o,f)   ((o)->i32Flags |= (f))
#define CLEARFLAG(o,f) ((o)->i32Flags &= ~(f))
#define HASFLAG(o,f)   ((o)->i32Flags & (f))

/* enum of the array types for certain opcodes ****************************/

/*
 * @doc TYPE
 * @enum tAType | These are used for defining the type of an array in the
 *                tArray struct.
 *
 */

typedef enum tatype
{
  T_ARRAY = 1,   /* @emem For an array of arrays */
  T_BOOLEAN = 4, /* @emem For an array of booleans */
  T_CHAR,        /* @emem For an array of 16-bit Unicode characters */
  T_FLOAT,       /* @emem For an array of floats */
  T_DOUBLE,      /* @emem For an array of doubles */
  T_BYTE,        /* @emem For an array of bytes */
  T_SHORT,       /* @emem For an array of shorts */
  T_INT,         /* @emem For an array of ints */
  T_LONG,        /* @emem For an array of longs */
  T_OBJECT,      /* @emem For an array of objects (class instances or arrays) */
  T_VOID	/* @emem Not used for arrays, but represents the void primitive type */
} tAType;

#include "vm/structs/struct_tobject.h"

#ifndef _TOBJECT
#define _TOBJECT
/*
 * @doc
 * @type tObject | typedef of the tobject structure
 *
 */
typedef struct tobject tObject;
#endif /*_TOBJECT*/

#include "vm/structs/struct_tarray.h"

/*
 * @doc TYPE
 * @type tArray | typedef of the tarray structure
 *
 */
typedef struct tarray tArray;

/* definitions for handles */

typedef tObject** tOBREF;
typedef tArray** tARREF;

#ifdef EVICTIONS
#define DEREF(x) (ISPID(*((int32*)(x))) ? (*(RPOT_SwapIn((PID) *(x)))) : (*(x)))
#define ODEREF(x) (ISPID(*((int32*)(x))) ? ((tObject*) *(RPOT_SwapIn((PID) *(x)))) : ((tObject*) *(x)))
#define ADEREF(x) (ISPID(*((int32*)(x))) ? ((tArray*) *(RPOT_SwapIn((PID) *(x)))) : ((tArray*) *(x)))
/* This is a plain deref - just gives the contents regardless of its format */
#define PDEREF(x) (*(x))
#else
#define DEREF(x) (*(x))
#define ODEREF(x) ((tObject*) *(x))
#define ADEREF(x) ((tArray*) *(x))
#define PDEREF(x) (*(x))
#endif

/* struct for environment stack frame **************************************/

/*
 * @doc TYPE
 * @struct
 * This structure holds the information needed for execution of a method.  It
 * includes pointers to the current class, the current object and the current
 * method.  It also keeps the program counter and pointers to the code and to
 * space for the local variables and the operand stack.  If the flat stack is
 * being used, the structure also has to store the amount of space that has
 * been used in the current super-frame and whether or not the current frame
 * is the first one on the superframe.
 *
 * The data in fields of this structure should not be changed manually.  These
 * structures should only be manipulated by using the stack manipulation
 * functions.
 *
 */

//Modifying for NMS

#include "vm/garbage/heap_type.h"

struct tstackframe
{
#ifdef DEBUG_FRAME_FOR_GC
  int32 magic1;
#endif
  struct tstackframe* pstPrevFrame; /* @field Pointer to the previous stack frame */
  struct tstackframe* pstChildFrame; /* @field Pointer to the next stack frame */
  tClassLoaderTuple*  pstCurrClass;            /* @field Pointer to current class */
  tOBREF   pstCurrObject;           /* @field Pointer to current object */
  tMethod* pstCurrMethod;           /* @field Pointer to current method */
  byte*    pbPC;                    /* @field Program counter - points to current instruction / operand */
  int32*   pi32Vars;                /* @field Pointer to space for local variables */
  int32*   pi32OpBot;               /* @field Pointer to beginning of operand stack */
  int32*   pi32OpTop;               /* @field Pointer to end of operand stack - used for popping and pushing data */
  byte*    pbCode;                  /* @field Pointer to the beginning of the bytecode being executed */
  
  uint16   iNumStackFrames;
  uint16   iCumVarData;
  byte     bSuperFrame;           /* @field Flag to mark if this is the first frame in a super-frame */
  byte     bFirstFrame;             /* @field Flag to mark if this is an initial stack frame (NOT the first frame in a super-frame as it used to be) */
  byte   bIsNativeFrame;	    /* Indicates this a frame for an optimised method */
  byte   bIsOrphan;		    /* Indicates this an orphan frame, this means when execution ends it should not go on with the previous frame */
  tOBREF pstException;              /* @field This points to an exception if one was thrown and not caught */
  tAllocatorHeap* pstHeap; //Points to heap for this process (and this thread)
#ifdef DEBUG_FRAME_FOR_GC
  int32 magic2;
#endif
};

/*
 * @doc TYPE
 * @type tStackFrame | typedef of the tstackframe structure
 *
 */
typedef struct tstackframe tStackFrame;

#ifdef DEBUG_TRACE
extern int INTERP_TraceLocals;
extern int INTERP_TraceOpStack;
extern int INTERP_TraceOpCodes;
#endif

#endif
