#ifndef __GARBAGE_DEFS_H__
#define __GARBAGE_DEFS_H__

/* for marking objects and arrays for identification */
#define GARBAGE_OBJECT             1L
#define GARBAGE_ARRAY              2L
/* used to mask the type of the object for identification */
#define GARBAGE_TYPEMASK           3L

/* two bits are used for marking objects as reachable */
#define GARBAGE_REACHABILITY_MASK  12L
#define GARBAGE_F_REACHABLE        4L  /* reachable from a finalizable
					  object (only) */
#define GARBAGE_REACHABLE          8L  /* reachable from a normal object 
					  or a machine reference */

#ifdef PERSIST
#define GARBAGE_REACHABLEFROMRPOT  12L /* reachable from the RPOT */
					  
/* 16, 32 and 64 are used in interp.h */

#define GARBAGE_PERSISTENT         128L
#define GARBAGE_BEENSWOPPED        256L
#define GARBAGE_MEMSWOPPED         512L

#endif

/* for marking objects that have been finalized */
#define GARBAGE_FINALIZED          1024L

#endif

