#ifndef __PUBLIC_METHS_H__
#define __PUBLIC_METHS_H__

#include "config.h"

/* Lists the methods and structures to be used by the JVM, all other methods are internal to the collector
 */

#include "vm/interp.h" //for tOBREF
#ifndef TEASEME
#include <pthread.h>
#endif
#include "vm/jni.h"

#include "vm/garbage/heap_type.h"

tAllocatorHeap* ALLOCATOR_Init();
tOBREF OLDHEAP_Alloc(tAllocatorHeap* heap, int32 i32NumWords);
tObject* OLDHEAP_AllocObject(tAllocatorHeap* heap, int32 i32NumWords);

void ALLOCATOR_RegisterFinalizable(tOBREF obj, tAllocatorHeap* heap);
void ALLOCATOR_DeregisterFinalizable(tOBREF obj, tAllocatorHeap* heap);
tOBREF ALLOCATOR_GetFinalizationCandidate(tAllocatorHeap* heap);

int ALLOCATOR_gc(tAllocatorHeap* heap);
int ALLOCATOR_ISHANDLE(tAllocatorHeap* heap, tOBREF h);
int ALLOCATOR_getNumTotalWords(tAllocatorHeap* heap);
int ALLOCATOR_getNumFreeWords(tAllocatorHeap* heap);

tOBREF HANDLES_getFreeHandle(tAllocatorHeap* heap);
int inline HANDLES_InHandleBlock(tAllocatorHeap* heap, tOBREF h);

#endif
