#ifndef __BITFIELD_H__
#define __BITFIELD_H__

/* Some macros to manage the bitfield */

#define OLD_CLEAR_BIT(x) (heap->pi32Block[ (x) / 32 + heap->i32YoungHeapBFSize] &= ~( 1 << ((x) % 32)))
#define OLD_SET_BIT(x) (heap->pi32Block[ (x) / 32 + heap->i32YoungHeapBFSize ] |= ( 1 << ((x) % 32)))
#define IS_OLD_BIT_SET(x) (heap->pi32Block[ (x) / 32 + heap->i32YoungHeapBFSize ] & ( 1 << ((x) % 32)))
#define IS_ANY_OLD_BIT_SET(x) (heap->pi32Block[ (x) / 32 + heap->i32YoungHeapBFSize ])

#define YOUNG_CLEAR_BIT(x) (heap->pi32Block[ (x) / 32 ] &= ~( 1 << ((x) % 32)))
#define YOUNG_SET_BIT(x) (heap->pi32Block[ (x) / 32 ] |= ( 1 << ((x) % 32)))
#define IS_YOUNG_BIT_SET(x) (heap->pi32Block[ (x) / 32 ] & ( 1 << ((x) % 32)))

#endif
