/*
 * Copyright (C) 2001, John Leuner.
 *
 * This file is part of the kissme project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * @doc MODULE
 * @module cplist.h |
 *
 * Types and prototypes for the <class-pointer, loader> list.
 *
 */

#ifndef __CPTUPLELIST_H__
#define __CPTUPLELIST_H__

#include "vm/interp.h"
#include "vm/classfil.h"
#include "vm/uid.h"

/*
 * @doc TYPE
 * @struct tCPListElement |
 * The element type of the class-pointer list (really a binary tree). We need
 * to store the parent pointer so that we can use iteration to traverse the
 * tree in an in-order walk.
 *
 */

typedef struct tcptuplelistelement
{
  tClassLoaderTuple* pstClass; /* @parm Pointer to class,loader tuple */
  struct tcptuplelistelement* pstParent;/* @parm Pointer to parent element */
  struct tcptuplelistelement* pstLeft;  /* @parm Pointer to left element */
  struct tcptuplelistelement* pstRight; /* @parm Pointer to right element */
} tCPTupleListElement;

/* function prototypes */
void CPTUPLELIST_Insert(tClassLoaderTuple* pstClass); 

tClassLoaderTuple* CPTUPLELIST_Find 
( 
  char* pszName,
  tOBREF loader
) ;

tClassLoaderTuple* CPTUPLELIST_UidFind 
( 
  Uid uidName,
  tOBREF loader
) ;
//tClassLoaderTuple* CPTUPLELIST_Find(char* pszName);
//tClassLoaderTuple* CPTUPLELIST_UidFind(Uid uidName);

int CPTUPLELIST_IsEmpty(void);
void CPTUPLELIST_Empty(void);

void CPTUPLELIST_GoTop(void);
void CPTUPLELIST_Skip(void);
int CPTUPLELIST_IsMore(void);
tClassLoaderTuple* CPTUPLELIST_GetCurrentClass(void);
char* CPTUPLELIST_GetCurrentName(void);

void CPTUPLELIST_ClearChanged(void);
int CPTUPLELIST_HasChanged(void);

void CPTUPLELIST_Dump();
void CPTUPLELIST_DumpNode( 
 tCPTupleListElement* root, 
 int indent 
);

#endif /* #ifndef __CPLIST_H__ */

/* end of cplist.h */
