/*
 * Copyright (C) 2001, John Leuner.
 *
 * This file is part of the kissme project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>

#ifndef DADDY_IS_WATCHING
#error Bad boy!
#endif
/*
 * @doc MODULE
 * @module classfil.h |
 *
 * This file declares all the structures that are needed for use with
 * classes.  It also defines the macros that are used for extracting data
 * from the constant pool.
 *
 */


/*
 * Mon Jul 31 03:57:52 GMT+2 2000 - Jewel
 *            Removing all references to PRELOAD
 *
 *
 *
 *
 */
#ifndef __CLASSFILE_H__
#define __CLASSFILE_H__

/* number of paths allowed to search */
#define CLASSFILE_NUMCLASSPATHS 5

/* make sure that QUICK is defined if QUICK2 is defined */
#ifdef QUICK2
#ifndef QUICK
#define QUICK
#endif
#endif

#include "vm/stdtypes.h"
/* For Uid */
#include "vm/uid.h"

#ifdef PERSIST
#include "vm/store.h"
#endif

/*
 * tObject is typedef'd elsewhere as well, so we need to make sure that it's
 * only done once.
 *
 */
#ifndef _TOBJECT
#define _TOBJECT
/*
 * @doc TYPE
 * @type tObject | typedef of tobject struct
 *
 */
typedef struct tobject tObject;
#endif /*_TOBJECT*/


/* 
 * This structure is used to represent a native method within the Kissme
 * JVM.  It is JNINativeMethod, with the addition of the isSafe flag.
 */
typedef struct internalnativemethod {
  char* name; 
  char* signature; 
  void* fnPtr;
  int   isSafe;           /* if non-zero, it is safe to run the GC while
			     this native method is being called. */
} InternalNativeMethod;


/*
 * @doc TYPE
 * @type tClass | typedef of tclass struct. Needs to be a forward declaration
 *                as it is used in various other strutures as well.
 *
 */

typedef struct tclass tClass;
typedef struct tinnerclass tInnerClass;
typedef struct tclassloadertuple tClassLoaderTuple;

/* flag definitions for access flags ***************************************/

#define ACC_PUBLIC       0x0001
#define ACC_PRIVATE      0x0002
#define ACC_PROTECTED    0x0004
#define ACC_STATIC       0x0008
#define ACC_FINAL        0x0010
#define ACC_SYNCHRONISED 0x0020
#define ACC_VOLATILE     0x0040
#define ACC_TRANSIENT    0x0080
#define ACC_NATIVE       0x0100
#define ACC_INTERFACE    0x0200
#define ACC_ABSTRACT     0x0400

//floating point mode is fp_strict
#define ACC_STRICT	 0x0800 
#define ACC_PRIMITIVE    0x1000 //Added by Jewel Oct 99

#ifdef PERSIST
#ifdef EVICTIONS
/* this is used to flag fields swopped-out objects that were swizzled
   when they were swopped out so that they can be swizzled again when
   they are swopped in */ 
#error WE must change this flag, it conflicts with ACC_STRICT
#define ACC_SWIZZLED     0x0800
#endif
#endif

/*
 * @doc TYPE
 * @enum tConstType |
 * Names for the constant pool types. CONSTANT_Unicode doesn't appear in
 * the spec, but it seems to fit in at 2.
 *
 */

typedef enum tconsttype
{
  CONSTANT_Utf8 = 1,           /* @emem For UTF-8 encoded strings */
  CONSTANT_Unicode,            /* @emem For Unicode strings - this is old and shouldn't be used */
  CONSTANT_Integer,            /* @emem For integers */
  CONSTANT_Float,              /* @emem For single precision floats */
  CONSTANT_Long,               /* @emem For long integers */
  CONSTANT_Double,             /* @emem For double precision floats */
  CONSTANT_Class,              /* @emem For classes */
  CONSTANT_String,             /* @emem For built-in string objects */
  CONSTANT_Fieldref,           /* @emem For field references */
  CONSTANT_Methodref,          /* @emem For method references */
  CONSTANT_InterfaceMethodref, /* @emem For interface method references */
  CONSTANT_NameandType         /* @emem For name and type info */
} tConstType;


/* A flag to show that constant pool elements have been resolved */
#define CONSTANT_ResolvedFlag 0x10

/* To "and" with the type to get the type not including the resolved flag */
#define CONSTANT_TypeMask 0x0f

/*
 * @doc TYPE
 * @struct
 * This is the structure used for representing line number information in the
 * line number table.
 *
 */

struct tlinenumberinfo
{
  uint16 u16StartPC;    /* @field Starting PC of bytecode for the source line */
  uint16 u16LineNumber; /* @field Line number of the source line */
};

/*
 * @doc TYPE
 * @type tLineNumberInfo | typdef of tlinenumberinfo struct
 *
 */

typedef struct tlinenumberinfo tLineNumberInfo;

/*
 * @doc TYPE
 * @struct
 * This is the structure used for storing line number information. It's only
 * used for source level debugging.
 *
 */

struct tlinenumbertable
{
  uint16 u16LineNumberTableLength;     /* @field Number of entries */
  tLineNumberInfo* pstLineNumberTable; /* @field The entries */
};

/*
 * @doc TYPE
 * @type tLineNumberTable | typdef of tlinenumbertable struct
 *
 */

typedef struct tlinenumbertable tLineNumberTable;

/*
 * @doc TYPE
 * @struct
 * This is the structure used for representing local variable information in
 * the local variable table.
 *
 */

struct tlocalvariableinfo
{
  uint16 u16StartPC;         /* @field Start PC of use of local variable */
  uint16 u16Length;          /* @field End PC of use of local variable */
  uint16 u16NameIndex;       /* @field Index of name in constant pool */
  uint16 u16SignatureIndex;  /* @field Index of signature in constant pool */
  uint16 u16Slot;            /* @field Which local variable slot it uses */
};

/*
 * @doc TYPE
 * @type tLocalVariableInfo | typdef of tlocalvariableinfo struct
 *
 */

typedef struct tlocalvariableinfo tLocalVariableInfo;

/*
 * @doc TYPE
 * @struct
 * This is the structure used for storing local variable information. It's only
 * used for source level debugging.
 *
 */

struct tlocalvariabletable
{
  uint16 u16LocalVariableTableLength;        /* @field Size of table */
  tLocalVariableInfo* pstLocalVariableTable; /* @field Entries in table */
};

/*
 * @doc TYPE
 * @type tLocalVariableTable | typdef of tlocalvariabletable struct
 *
 */

typedef struct tlocalvariabletable tLocalVariableTable;

#include "vm/structs/struct_texceptioninfo.h"

/*
 * @doc TYPE
 * @type tExceptionInfo | typdef of texceptioninfo struct
 *
 */

typedef struct texceptioninfo tExceptionInfo;

#include "vm/structs/struct_tcode.h"

/*
 * @doc TYPE
 * @type tCode | typdef of tcode struct
 *
 */

typedef struct tcode tCode;

#include "vm/structs/struct_tmethod.h"

/*
 * @doc TYPE
 * @type tMethod | typdef of tmethod struct
 *
 */

typedef struct tmethod tMethod;

/*
 * @doc TYPE
 * @struct
 * This structure is used to store information about fields in a class.
 *
 */

struct tfield
{
#ifdef CLASSPERSIST
  PID pid;
#endif
  uint16 u16AccessFlags;     /* @field The field's access flags */
  Uid uidFieldName;          /* @field Pointer to field's name */
  Uid uidFieldSig;           /* @field Pointer to field's signature */
  uint16 u16ConstValueIndex; /* @field Index of constant value in const pool */
  uint16 u16Offset;          /* @field Offset in variable array. */
  tClassLoaderTuple* pstClass;          /* @field Pointer to class */
#ifdef RESURRECT_QUICK
  int32* pi32Addr;           /* @field Actual address - used for QUICK */
#endif
};

/*
 * @doc TYPE
 * @type tField | typdef of tfield struct
 *
 */

typedef struct tfield tField;

#include "vm/structs/struct_tclassfil.h"
#include "vm/structs/struct_tclassloadertuple.h"

/* end of classfil.h */
#endif
