#include "config.h"

/*
 * native methods for the plava.PStore class.
 *
 */

#ifndef GARBAGE
#error GARBAGE must be defined for PStore
#endif

/* just for NULL */
#include <stdlib.h>
#include <stdio.h>

#include "vm/garbage.h"
#include "vm/jni.h"
#include "vm/cplist.h"

#include "vm/store.h"
#include "vm/interp_methods.h"
#include "vm/rpot.h"

extern int use_persistent_store;


/*
 * public native void stabiliseAll();
 */
void plava_PStore_stabiliseAll(JNIEnv* env,   /* JNI environment */
			       jobject obj    /* target object */)
{
#ifdef PERSIST
  RPOT_StabiliseAll();
#else
  (*env)->Throw(env, INTERP_ExceptionObjectFromNameAndMessage(env, 
                "plava/StoreNotFoundException", 
		 "Kissme not compiled with persistence support"));
#endif
}
 

jobject plava_PStore_nativeGetRootObject(JNIEnv* env,   /* JNI environment */
					 jclass thisClass)
{
#ifdef PERSIST
  PID pid;
  
  /* fault in the root object and return its LA */
  if (!use_persistent_store) {
    (*env)->Throw(env, INTERP_ExceptionObjectFromNameAndMessage(env, 
                               "plava/StoreNotFoundException", 
			       "Kissme started without a \"-store\" option"));
    return NULL;
  }
 
  pid = STORE_GetRootPID();

  if (pid) {
    return RPOT_FaultObject(pid);
  }
  else {
    return NULL;
  }
#else
  (*env)->Throw(env, INTERP_ExceptionObjectFromNameAndMessage(env, 
                "plava/StoreNotFoundException", 
		 "Kissme not compiled with persistence support"));
#endif
}


void plava_PStore_nativeSetRootObject(JNIEnv* env,   /* JNI environment */
				      jclass thisclass, //A static method
				      jobject obj)
{
#ifdef PERSIST
  PID pid;

  tracePersist("PStore_nativeSetRootObject: root object's class is %s",
	       ODEREF(obj)->pstType->uidName);
  tracePersist("PStore_nativeSetRootObject: calling RPOT_PromoteObject(%x)",
	       DEREF(obj));
  pid = RPOT_PromoteObject(DEREF(obj)); 

  tracePersist("PStore_nativeSetRootObject: calling STORE_SetRootPID(%x)", 
	       pid);
  STORE_SetRootPID(pid);

  // Force a full stabilise.  If we don't, and the application code or
  // VM doesn't do this later, a newly created store will be left in a
  // corrupt state.
  tracePersist0("PStore_nativeSetRootObject: forcing RPOT_StabiliseAll()");
  RPOT_StabiliseAll();
#else
  (*env)->Throw(env, INTERP_ExceptionObjectFromNameAndMessage(env, 
                "plava/StoreNotFoundException", 
		 "Kissme not compiled with persistence support"));
#endif
}

