#include "config.h"
/*
 * Native methods for VMThrowable class.
 *
 */

/*
  public native VMThrowable fillInStackTrace(Throwable);
*/

#include <stdio.h>
#include <string.h>

#include "vm/interp.h"
#include "vm/jni.h"
#include "vm/interp_methods.h"

#include "vm/thread.h"
#include "vm/classfile_methods.h"
#include "vm/newobject.h"
#include "vm/global.h"
#include "lib/indigenous/java.lang/VMClass.h"
#include "lib/indigenous/java.lang/Class.h"
#include "lib/indigenous/java.lang/Class_Reflection.h"
#include "vm/threadinfo.h"

jobject java_lang_VMThrowable_fillInStackTrace(JNIEnv* env, 
					       jobject throwableObject)
{
  tStackFrame* f;

  /* We need these to set the trace field in the VMThrowable object*/
  jfieldID stackTraceFieldID;
  jclass VMThrowable_cls = (*env)->FindClass(env, "java/lang/VMThrowable");
  jobject vmThrowable_obj = NULL;

#ifdef HIDE_EXCEPTION_CONSTRUCTION
  jclass throwable_cls = (*env)->FindClass(env, "java/lang/Throwable");
#endif

  int num_frames = 0;
  int i;
  int j;
  jarray elemArray = NULL;
  jclass StackTraceElement_cls = 
    (*env)->FindClass(env, "java/lang/StackTraceElement");

  int num_initial_frames = 0;

  num_initial_frames = 
    THREADINFO_countInitialStackFramesFromNode(THREAD_FindThread());

  assert(num_initial_frames > 0);
  for (j = 0; j < (num_initial_frames); j++) {
    tStackFrame* topFrame = 
      THREADINFO_getInitialStackFrameFromNode(THREAD_FindThread(), j);
    // First count the number of frames
    f = topFrame;
    while (f != NULL) {
#ifdef HIDE_EXCEPTION_CONSTRUCTION 
      if ((throwable_cls != NULL && f->pstCurrObject != NULL)
	  && (*env)->IsInstanceOf(env, f->pstCurrObject, throwable_cls)) {
	/* */
      }
      else
#endif
	num_frames ++;
      f = f->pstChildFrame;
    }
  } 

  traceExceptions("VMThrowable.fillInStackTrace: %i initial frames and "
		  "%i frames, object %p", 
		  num_initial_frames, num_frames, throwableObject);
  
  // Create an array of StackTraceElement's
  elemArray = (*env)->NewObjectArray(env, num_frames, 
				     StackTraceElement_cls, NULL);   
  if (elemArray == NULL) {
    panic("Cannot create StackTraceElement[%d]", num_frames);
    return NULL;
  }
  i = 0;
  
  for (j = num_initial_frames; j >= 0; j--) {
    tStackFrame* topFrame =
      THREADINFO_getInitialStackFrameFromNode(THREAD_FindThread(), j);
    
    f = topFrame;
    
    while (f != NULL) {
      jobject sourceFile;
      char* sourceFileAsciiz;
      char* tmpClassName;
      int len, k;
      
      //Create each StackTraceElement
      jobject stackObject;
      
      jmethodID consMID = 
	(*env)->GetMethodID(env, StackTraceElement_cls, "<init>", 
			    "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Z)V");
      if (consMID == NULL) {
	panic0("Can't find the constructor for StackTraceElement");
	return NULL;
      }
      
#ifdef HIDE_EXCEPTION_CONSTRUCTION
      if ((throwable_cls != NULL && f->pstCurrObject != NULL)
	  && (*env)->IsInstanceOf(env, f->pstCurrObject, throwable_cls)) {
	/* */
      }
      else {
#endif
	tClassLoaderTuple* tuple = f->pstCurrMethod->pstClass;

	/* and get the source file */
	if (tuple->pstClass->u16SourceFile) {
	  sourceFileAsciiz =
	    CONSTGET_UidAsciz(tuple->pstClass, tuple->pstClass->u16SourceFile);
	  sourceFile = INTERP_NewStringFromAsciz(env, sourceFileAsciiz);
	}
	else {
	  sourceFileAsciiz = "none";
	}
	
	/* rewrite the class UID into a properly qualified name */
	len = strlen(tuple->uidName);
	tmpClassName = sys_malloc(len + 1);
	strcpy(tmpClassName, tuple->uidName);
	for (k = 0; k < len; k++) {
	  if (tmpClassName[k] == '/') {
	    tmpClassName[k] = '.';
	  }
	}
	
	stackObject = 
	  (*env)->NewObject(env, StackTraceElement_cls, consMID, sourceFile, 
			    INTERP_FigureOutLineNumber(f), 
			    INTERP_NewStringFromAsciz(env, tmpClassName), 
			    INTERP_NewStringFromAsciz(env, f->pstCurrMethod->uidName), 
			    (f->pstCurrMethod->u16AccessFlags & ACC_NATIVE ? 
			     JNI_TRUE : JNI_FALSE));
	traceExceptions("StackTraceElement[%i] <- %s:%i %s.%s %s",
			i, sourceFileAsciiz, INTERP_FigureOutLineNumber(f), 
			tmpClassName, f->pstCurrMethod->uidName,
			(f->pstCurrMethod->u16AccessFlags & ACC_NATIVE ? 
			 "(native)" : ""));
	sys_free(tmpClassName);
	
	assert((i) < num_frames);
	(*env)->SetObjectArrayElement(env, elemArray, (num_frames - i - 1), 
				      stackObject);
	i++;
#ifdef HIDE_EXCEPTION_CONSTRUCTION
      }
#endif
      f = f->pstChildFrame; 
    }
  }
 
  vmThrowable_obj = (*env)->AllocObject(env, VMThrowable_cls);
  if (vmThrowable_obj == NULL) {
    panic("Cannot create VMThrowable for stacktrace\n");
    return NULL;
  }
  stackTraceFieldID = (*env)->GetFieldID(env, VMThrowable_cls, "stackTrace", 
					 "[Ljava/lang/StackTraceElement;");
  
  if (stackTraceFieldID == NULL) {
    //we can't actually throw an exception
    panic0("No stackTrace field in java/lang/VMThrowable\n");
    return NULL;
  }
  (*env)->SetObjectField(env, vmThrowable_obj, stackTraceFieldID, elemArray);
  return vmThrowable_obj;
}
