#ifndef __VMCLASSLOADER_H__
#define __VMCLASSLOADER_H__

#include "vm/jni.h"
#include "vm/structs/struct_tarray.h"

jclass java_lang_VMClassLoader_getPrimitiveClass(JNIEnv* env, jclass clazz,
						 jchar type);

void java_lang_VMClassLoader_resolveClass(JNIEnv* env, jclass clazz, 
					  jclass cls);

jclass java_lang_VMClassLoader_loadClass(JNIEnv* env, jclass clazz, 
					 jobject name, jboolean resolve);

jclass java_lang_VMClassLoader_defineClass(JNIEnv* env, jclass clazz, 
					   jobject classloader,
					   jobject namestring, jarray data,
					   jint offset, jint len);

int java_lang_VMClassLoader_makePrimitiveTypes(JNIEnv* env);
jclass java_lang_VMClassLoader_getPrimitiveClassFromAsciz (JNIEnv* env,
							   const char* name);
jclass java_lang_VMClassLoader_getPrimitiveClassFromCode(JNIEnv* env, 
							 tAType code);
jclass java_lang_VMClassLoader_getPrimitiveWrapperClassFromCode(JNIEnv* env, 
								tAType code);
tOBREF* java_lang_VMClassLoader_getPrimitiveClassLoc(int index);
tOBREF* java_lang_VMClassLoader_getPrimitiveWrapperClassLoc(int index);

#endif
