#ifndef __CLASS_REFLECTION_H__
#define __CLASS_REFLECTION_H__

jobjectArray CLASS_GetClassArrayFromSig(JNIEnv* env, char* sig, 
					tClassLoaderTuple* loadingClass);
jclass CLASS_GetPrimitiveClass(JNIEnv* env, char type);
int CLASS_UnwrapObject(JNIEnv* env, jobject object, jvalue* retval);
jclass CLASS_GetWrapperClass(JNIEnv* env, jclass primClass);
jboolean CLASS_CheckWrapperWidening(JNIEnv* env, jclass targetClass, 
				    jclass suppliedClass);

jboolean Java_java_lang_VMClass_isPrimitiveWrapper(JNIEnv* env, jobject clazz);

int CLASS_WidenResult(JNIEnv* env, jclass targetClass, jclass suppliedClass,
		      jvalue* retval);

int CLASS_CompareClassArrays(JNIEnv* env, jobjectArray a, jobjectArray b);

Uid CLASS_GetSigFromClassArray(JNIEnv* env, tArray* args);
int ConvertClassToSig(JNIEnv* env, tClassLoaderTuple* clazz, int primitive);
int CLASS_getDeclaringClass(JNIEnv* env,tClassLoaderTuple* startingClass, 
			    tMethod* method, jclass* origClazz, 
			    int* slotIndex);

int CLASS_CreateReflectedMethodArguments(JNIEnv* env, tMethod* method, 
					 jobjectArray args, 
					 jvalue** ret_array);
int CLASS_CheckNumReflectionMethodArguments(JNIEnv* env, tMethod* method,
					    jobjectArray args);


//tOBREF CLASS_MakeClassObject(JNIEnv* env, tClassLoaderTuple* tuple);

jclass CLASS_GetClassFromSig(JNIEnv* env, char* pszSignature, 
			     tClassLoaderTuple* loadingClass, int index);


tOBREF CLASS_CreateInvocationTargetException(JNIEnv* env);

#endif
