package hitme.plava;

import plava.*;

/**
 * Testing the PStore class
 */
public class PStoreTree extends hitme.HitMeTest
{
  // Note: Increasing DEPTH above 17 will give an out-of-memory error
  // with the default heap size.
  private static int DEPTH = 17;
  
  private static int NODE_COUNT = (1 << DEPTH) - 1;
  private int count;

  private class Node {
    public Node left;
    public Node right;
    public int value;
    public Node(Node left, Node right, int value) {
      this.left = left;
      this.right = right;
      this.value = value;
    }
  }

  public String describe() {
    return "save / restore a persistent tree with " + NODE_COUNT + " nodes";
  }
  
  public void test() {
    try {
      PStore store = PStore.getStoreRoot();
      Object tree = store.getRoot("tree");
      if (tree == null) {
	tree = createTree(DEPTH);
	checkTree(tree);
	store.addRoot("tree", tree);
      }
      else {
	checkTree(tree);
      }
    }
    catch (StoreNotFoundException ex) {
      err(ex);
    }
  }

  private Node createTree(int depth) {
    if (depth <= 0) {
      return null;
    }
    else {
      return new Node(createTree(depth - 1), createTree(depth - 1), ++count);
    }
  }

  private void checkTree(Object tree) {
    count = 0;
    if (!checkTree0((Node) tree, DEPTH)) {
      err("Tree check failed");
    }
  }

  private boolean checkTree0(Node tree, int depth) {
    if (depth <= 0) {
      return tree == null;
    }
    else {
      return (checkTree0(tree.left, depth - 1) &&
	      checkTree0(tree.right, depth - 1) &&
	      tree.value == ++count);
    }
  }
}
