package hitme.plava;

import plava.*;

/**
 * Testing the PStore class
 */
public class PStoreObjectArray extends hitme.HitMeTest
{

  public String describe() {
    return "save / restore an Object[] as PStore root object";
  }
  
  public void test() {
    try {
      Object o = PStore.nativeGetRootObject();
      if (o == null) {
	PStore.nativeSetRootObject(new Object[]{null, 
						new Object(), 
						new Object()});
      }
      else {
        Object[] objects = (Object[]) o;
	check(objects.length == 3, "wrong size");
	check(objects[0] == null, "objects[0] != null");	
	check(objects[1] != objects[2], "objects[1] == objects[2]");
      }
    }
    catch (StoreNotFoundException ex) {
      err(ex);
    }
  }
}
