package hitme.plava;

import plava.*;

/**
 * Testing the PStore class
 */
public class PStoreIntegerArray extends hitme.HitMeTest
{

  public String describe() {
    return "save / restore an Integer[] as PStore root object";
  }
  
  public void test() {
    try {
      Object o = PStore.nativeGetRootObject();
      if (o == null) {
	PStore.nativeSetRootObject(new Integer[]{new Integer(1), 
						 new Integer(2), 
						 new Integer(3)});
      }
      else {
        Integer[] integers = (Integer[]) o;
	check(integers.length == 3, "wrong size");
	check(integers[0].intValue() == 1, "integers[0] != 1");	
	check(integers[1].intValue() == 2, "integers[1] != 2");	
	check(integers[2].intValue() == 3, "integers[2] != 3");
      }
    }
    catch (StoreNotFoundException ex) {
      err(ex);
    }
  }

}
