package hitme.plava;

import plava.*;

/**
 * Testing the PStore class
 */
public class PStoreCharArray extends hitme.HitMeTest
{
  
  public String describe() {
    return "save / restore an char[] as PStore root object";
  }
  
  public void test() {
    try {
      Object o = PStore.nativeGetRootObject();
      if (o == null) {
	PStore.nativeSetRootObject(new char[]{1, 2, 3});
      }
      else {
        char[] chars = (char[]) o;
	check(chars.length == 3, "wrong size");
	check(chars[0] == 1, "chars[0] != 1");	
	check(chars[1] == 2, "chars[1] != 2");	
	check(chars[2] == 3, "chars[2] != 3");
      }
    }
    catch (StoreNotFoundException ex) {
      err(ex);
    }
  }
}
