package hitme.basic.types;

/**
 * Testing the 'long' data type
 *
 * (Was kissme_test.LongTest)
 */
public class LongType extends hitme.HitMeTest {
  
  // This routine might be trying to test tail recursion optimization ...
  // but if so, it is relying on wrap-around arithmetic to terminate!
  public static long callme(long a, long b)
  {
    if ((a + b) < 50) {
      return a + b;
    }
    else {
      return callme(a + b, b);
    }
  }
  
  public void workit()
  {
    long a, b, c, d, e, f, g, h;
    
    a = 2;
    b = 3;
    c = 4;
    d = 5;
    e = 6;
    f = 7;
    g = 8;
    h = 9;

    check(a == 2, "a != 2");    
    check(a == 2L, "a != 2L");
    check(h == 9, "h != 9");
    check(h == 9L, "h != 9L");
    
    a = b + c + d + e + f + g + h;

    check(a == 42, "a != 42");

    h = callme(d, e);

    check(h == 11, "h != 11");

    long[] mlarray = new long[22];
    
    mlarray[0] = a;
    mlarray[1] = b;
    mlarray[2] = c;
    mlarray[3] = d;
    mlarray[4] = e;
    
    f = mlarray[0];
    g = mlarray[1];
    h = mlarray[2];

    check(a == f, "a != f");
    check(b == g, "b != g");
    check(c == h, "c != h");
    
    long divop1 = 22;
    long divop2 = 3;
    
    long res = divop1 / divop2;
    long mod = divop1 % divop2;
    
    check(res == 7, "/ failed");
    check(mod == 1, "% failed");
    
    long count = 0;
    long biglong = 0x1000000000L;
    while (biglong != 0) {
      biglong /= 0x10;
      count += 1;
    }
    check(count == 10, "/= failed");

    count = 0;
    biglong = 1L;
    while (biglong != 0x1000000000L) {
      biglong *= 2;
      count += 1;
    }
    check(count == 36, "*= failed");

    try {
      long one = 1;
      long zero = 0;
      long infinity = one / zero;
      check(false, "no divide by zero exception");
    } catch (ArithmeticException ex) { /* */ }
  }

  public String describe() {
    return "'long' test";
  }
  
  public void test() 
  {    
    workit();
    workit();
  }
}
