package hitme.basic.types;

/**
 * Testing the 'float' data type
 */
public class FloatType extends hitme.HitMeTest {

  public float zero() {
    return 0.0f;
  }
  
  public void test() 
  {
    float nan1 = 0.0f / 0.0f;
    float nan2 = zero() / zero();
    float nan3 = Float.NaN;
    
    check(Float.isNaN(nan1), "0.0f / 0.0f is not NaN");
    check(Float.isNaN(nan2), "zero() / zero() is not NaN");
    check(Float.isNaN(nan3), "Float.NaN is not NaN");

    Float b1 = new Float(3.4e+32f);
    Float b2 = new Float(-23.45f);
    
    int i1 = b1.intValue();
    int i2 = b2.intValue();
    
    check(i1 == (int) 3.4e+32f, "intValue returned wrong results - 1");
    check(i2 == (int) -23.45f, "intValue returned wrong results - 2");  
    
  }
  
  public String describe() {
    return "'float' test";
  }
}
