package hitme.basic.lang;

import java.io.*;

/**
 * Testing thread interrupts
 */
public class ThreadInterrupts extends hitme.HitMeTest implements Runnable
{
  private int counter = 0;

  public class Reader implements Runnable {
    public void run() {
      try {
	while (true) {
	  int ch = System.in.read();
	}
      }
      catch (InterruptedIOException ex) {
	/* */
      }
      catch (IOException ex) {
	err("Unexpected IException: " + ex.getMessage());
      }
    }
  }

  public String describe() {
    return "thread interrupt test";
  }

  public void run() { 
    for (int i = 0; i < 5; i++) {
      try {
	Thread.sleep(0);
	err("worker thread returned from sleep(0) call");
      }
      catch (InterruptedException ex) {
      	counter++;
	check(!Thread.currentThread().interrupted(),
	      "interrupted flag was not cleared");
      }
    }
  }
  
  public void test() {
    try {
      Thread t = new Thread(this);
      t.start();
      
      for (int i = 0; i < 5; i++) {
	Thread.sleep(1000);
	check(counter == i, "missed interrupt: i == " + i);
	t.interrupt();
      }
      Thread.sleep(1000);

      check(!t.isAlive(), "worker thread should be dead now");
      
      Thread t2 = new Thread(this);
      t2.start();
      
      Thread.sleep(1000);
      t2.interrupt();
      Thread.sleep(1000);
      
      check(!t2.isAlive(), "reader thread should be dead now");
    }
    catch (InterruptedException ex) {
      err(ex);
    }  
    
  }
}
