package hitme.basic.lang;

/**
 * Testing behaviour when we run out of memory
 */
public class OutOfMemory extends hitme.HitMeTest 
{

  public class Tree {
    private Tree left, right;
    public Tree(Tree left, Tree right) {
      this.left = left;
      this.right = right;
    }

    public Tree(int depth) {
      if (depth == 1) {
	left = null; 
	right = null;
      }
      else {
	left = new Tree(depth - 1);
	right = new Tree(depth - 1);
      }
    }
  }

  public String describe() {
    return "GC test - \"out of memory\" recovery";
  }
  
  public void test() {
    Tree tree = new Tree(1);
    try {
      for (int i = 2; i < 1000; i++) {
	tree = new Tree(tree, new Tree(i - 1));
      }
    }
    catch (OutOfMemoryError er) {
      int[] bigArray = new int[10000];
    }
  }
}
