package hitme.basic.lang;

/**
 * Testing garbage collection / thread interactions
 */
public class GCAndThreads extends hitme.HitMeTest
{
  public class Sleeper implements Runnable
  {
    public void run() {
      try {
	Thread.sleep(0);
      }
      catch (InterruptedException ex) {
      }
    }
  }

  
  public class Looper implements Runnable
  {
    public void run() {
      while (!Thread.currentThread().isInterrupted()) {
      }
    }
  }


  public class Waiter implements Runnable
  {
    public synchronized void run() {
      try {
	this.wait();
      }
      catch (InterruptedException ex) {
      }
    }
  }


  public String describe() {
    return "GC / thread interaction test";
  }
  
  public void test() {
    Thread t1 = new Thread(new Sleeper());
    Thread t2 = new Thread(new Looper());
    Thread t3 = new Thread(new Waiter());
    
    // Generate large amounts of garbage.  If something goes wrong with
    // the GC / thread synchro, we might expect GC to be blocked.

    for (int i = 0; i < 1000000; i++) {
      byte[] junk = new byte[16];
    }

    t1.interrupt();
    t2.interrupt();
    t3.interrupt();

    check(!t1.isAlive(), "Sleeper thread not dead");
    check(!t2.isAlive(), "Looper thread not dead");
    check(!t3.isAlive(), "Waiter thread not dead");
  }
}
