/*
 * kissme compile-time configuration flags
 */

// Set this flag to compile kissme as a Linux user-mode program
#define KISSME_LINUX_USER

// Set this flag to allocate the condition variable inside the object header.
// This saves us doing a malloc/free for each new object
#ifdef KISSME_LINUX_USER
#define IN_PLACE_CONDITION
#endif

// Set this flag to enable dynamic linking of JNI shared libraries
#define DLOPEN 

// Set this flag to use GNU Classpath shared libraries
#define USE_SHARED_CP_LIBS

// Garbage and memory management flags, GARBAGE must always be on. 
// The rest you probably shouldn't change.
#define GARBAGE
#define HANDLEBLOCKS

// 2nd generation GC code, uses GC points
#define GARBAGE2
#define ALLOCATOR

// Set this flag to enable VM support for 'plava' orthogonal persistence.
#define PERSIST

// Not sure what these do.  Leave them alone
#define NEWRPOT
#define RPOTREFS

// Set this flag to use IBM flat and inflated locks -- this is still 
// experimental, but enabled for this release
#define IBM_LOCKS

// Set this flag to enable a variation on the above with contention bit 
// in thread structure
#define SABLE_LOCKS 

// Set this flag to uses a new form of method stacks. 
// The alternative apparently hasn't been tested in a long time.
#define THREAD_EXPERIMENT

// Set this flag to preallocate the OutOufMemoryException object
#define PREALLOCATE_OOM

// Use QUICK instructions, leave this on for the Optimiser
//#define RESURRECT_QUICK

// Set this flag to use Classpath file IO native code rather than our own. 
// Classpath is much more robust.
#define CLASSPATH_FILE_IO

// Set this flag to use Classpath BigInteger native code.
#define CLASSPATH_BIGINTEGER

#define NETWORKING
#define CLASSPATH_NETWORKING

// Set this to enable GTK peer support 
//#define GTKPEER

// When printing out stack traces, the IBM JDK behaviour is to print out 
// the frames for the construction of the exception object.  The Sun JDK
// hides the exception construction

// Set this flag to hide the frames for the exception constructor in a
// stack trace
#define HIDE_EXCEPTION_CONSTRUCTION

// Set this flag to enable additional sanity checking / tracing of
// stack frames (this will slow things down a lot)
//#define DEBUG_FRAMES

// Set this flag to enable miscellaneous sanity checking / trace printing
//#define DEBUG

// Set this flag to enable toggleable tracing of Java opcodes and stacks.
//#define DEBUG_TRACE

// Set this flag to enable tracing of class file decoding
//#define CLASSFILE_TRACE

// Set this flag to enable assertions checking (new)
#define ASSERTIONS

// Set this flag to enable trace printing (new)
#define TRACING

// Garbage collector debugging

// Set this flag to enable guard fields around Java objects and 
// classloadertuple objects.  These are checked at key points in
// the garbage collector to detect heap corruption.
//#define DEBUG_OBJECT_FOR_GC

// Set this flag to enable guard fields in class tuple objects
//#define DEBUG_CLASS_FOR_GC

// Set this flag to enable guard fields in stack frame objects
//#define DEBUG_FRAME_FOR_GC

// Set this flag to enable additional garbage collector trace prints
//#define GARBAGE_VERBOSE

// Set this flag to enable extra class loading related trace prints 
//#define LOADING_VERBOSE

// Set this flag to enable additional persistence trace prints
//#define PERSIST_VERBOSE

// Set this flag to enable tracing and sanity checking of the CPLIST
// data structure. 
//#define DEBUG_CPLIST

// Set this flag to enable debug statements for floating point ops. 
//#define DEBUG_FLOAT

// Set this flag to enable a brute-force check which tries to trap errant
// pointer errors ASAP
//#define HASH_INTEGRITY_CHECK 

// Set this flag to enable jos stuff to access raw hardware
//#define RAWVIDEO

// Set this flag to use the ncurses library to provide text access in jos
//#define CURSES_CONSOLE

#define HAVE_JVMDI

//
// The remainder of this file probably should not be touched.
//

#include "vm/sys_linux_host/wrappers.h"
#include "vm/diag.h"

#ifdef DEBUG_OBJECT_FOR_GC
#define OMAGIC1 0x55555555
#define OMAGIC2 0xAAAAAAAA
#endif

#ifdef DEBUG_CLASS_FOR_GC
#define CMAGIC1 0x5A5A5A5A
#define CMAGIC2 0xA5A5A5A5
#endif

#ifdef DEBUG_FRAME_FOR_GC
#define FMAGIC1 0x1F1F1F1F
#define FMAGIC2 0xF1F1F1F1
#endif

// Vendor for the Java Virtual Machine (Kissme)
#define KISSME_VENDOR "John Leuner"
#define KISSME_VENDOR_URL "http://kissme.sourceforge.net"

// Vendor for the Java Runtime Environment (Classpath)
#define JAVA_VENDOR "Free Software Foundation"
#define JAVA_VENDOR_URL "http://www.gnu.org"

#define DEFAULT_KISSME_HOME "/usr/kissme-jdk"
#define DEFAULT_JIT_COMPILER "NONE"

#define KISSME_VERSION "0.0.31"
#define KISSME_BUILD_DATE __DATE__


// This is just a way to check that all files include this one
#define DADDY_IS_WATCHING

