package plava;

public class PStore
{
  private static boolean storeOpen = false;
  private static final int MAXNUMROOTS = 5;

  private int maxNumRoots;
  private int numRoots;
  private PRoot roots[];

  private static boolean debug = false;

  public static PStore getStoreRoot () throws StoreNotFoundException
  {
    if (debug) {
      System.out.println("PStore.getStoreRoot");
    }
    PStore p = (PStore) nativeGetRootObject();
    if (p == null) {
      if (debug) {
	System.out.println("PStore.getStoreRoot: nativeGetRootObject " +
			   "returned null, creating new roots");
      }
      p = new PStore();
      p.roots = new PRoot[MAXNUMROOTS];
      if (debug) {
	System.out.println("PStore.getStoreRoot: Calling nativeSetRootObject" +
			   " to set new roots");
      }
      nativeSetRootObject(p);
    }
    return p;
  }

  /**
   * Adds a persistent root to the store.
   */
  public void addRoot(String n, Object o)
  {
    if (debug) {
      System.out.println("PStore.addRoot");
    }
    numRoots += 1;
    if (numRoots > maxNumRoots) {
      PRoot newRoots[] = new PRoot[maxNumRoots * 2];
      for (int i = 0; i < maxNumRoots; i++) {
	newRoots[i] = roots[i];
      }
      maxNumRoots *= 2;
      roots = newRoots;
    }
    roots[numRoots - 1] = new PRoot(n, o);
  }
  
  /**
   * Returns a named persistent root.
   */
  public Object getRoot(String name)
  {
    int i;
    if (debug) {
      System.out.println("PStore.getRoot (" + name + ")");
    }
    for (i = 0; i < numRoots; i++) {
      if (roots[i].name.compareTo(name) == 0) {
        return roots[i].obj;
      }
    }
    return null;
  }

  /**
   * Set root -- added by Jewel 19/9/99 
   */
  public void setRoot(String name, Object obj)
  {
    int i;
    if (debug) {
      System.out.println("PStore.setRoot (" + name + ")");
    }
    for (i = 0; i < numRoots; i++) {
      if (roots[i].name.compareTo(name) == 0) {
        roots[i].obj = obj;
      }
    }
  }

  /**
   * Default constructor - just sets maxNumRoots and numRoots
   */
  private PStore () 
  {
    maxNumRoots = MAXNUMROOTS;
    numRoots = 0;
  }
  
  public native void stabiliseAll();

  // Should really be private ... 
  public static native Object nativeGetRootObject()
    throws StoreNotFoundException;

  // Should really be private ... 
  public static native void nativeSetRootObject(Object o);
}











