#
# M4 macros for Kissme autoconfig
#

# This file is input to aclocal which generates aclocal.m4
# In turn, this an input to autoconf which generates ./configure

#############################################################################

# Find the Java compiler.  In Kissme, we use it to  compiling the VM
# specific Java classes, and test harness code.
AC_DEFUN(KISSME_PATH_JAVAC,
[
  AC_ARG_VAR(JAVAC, [The chosen Java Compiler])
  AC_ARG_WITH(java_compiler,
  [  --with-java-compiler    select a bytecode compiler [default=jikes,gcj,javac]],
  [
    if test "x${withval}" != x ; then
      if test `basename "${withval}"` = "${withval}" ; then
	AC_PATH_PROG(JAVAC,${withval})
      else
	AC_CHECK_FILE(${withval}, 
		      [JAVAC=${withval} ;
		       AC_SUBST(JAVAC)])
      fi
      if test x${JAVAC} = x ; then
        AC_MSG_ERROR([Cannot find the selected Java compiler (${withval}).])
      fi
    fi
  ])
  if test x${JAVAC} = x ; then
    AC_PATH_PROGS(JAVAC,[jikes gcj kjc javac])
  fi
  if test x${JAVAC} = x ; then
    AC_MSG_ERROR([Cannot find a Java compiler.])
  fi
  _KISSME_IDENTIFY_JAVAC(${JAVAC})
])

# Identify a Java compiler, setting the relevant 'USE' variable.  At
# the moment, just guess from the basename.
AC_DEFUN(_KISSME_IDENTIFY_JAVAC, [
  if test x$3 = x ; then
    _MSG=
  else
    _MSG="$3 "
  fi
  AC_MSG_CHECKING([${_MSG}java compiler type])
  if test x$1 != x ; then
    _BASENAME=`basename $1` ; USE_JIKES=no ; USE_GCJ=no ; USE_SUN_JAVAC=no
    if test ${_BASENAME} = jikes ; then
      USE_JIKES$2=yes
      AC_MSG_RESULT(jikes)
    elif test ${_BASENAME} = gcj ; then
      USE_GCJ$2=yes
      AC_MSG_RESULT(gcj)
    elif test ${_BASENAME} = javac ; then
      USE_SUN_JAVAC$2=yes
      AC_MSG_RESULT(javac)
    else
      AC_MSG_RESULT(unknown)
    fi
    AC_SUBST(USE_JIKES$2)
    AC_SUBST(USE_GCJ$2)
    AC_SUBST(USE_SUN_JAVAC$2)
  fi
])

#############################################################################

# Find the ZIP program
AC_DEFUN(KISSME_PATH_ZIP,
[
  AC_ARG_VAR(ZIP, [The chosen "zip" command])
  AC_PATH_PROG(ZIP,zip)
])


#############################################################################

# Locate a Kissme Classpath build directory
AC_DEFUN(KISSME_PATH_KCP_DIR, [
  AC_ARG_WITH(kcp, 
  [  --with-kcp              select the Kissme Classpath directory],
  [
    if test "x${withval}" = x ; then
      AC_MSG_ERROR([No value supplied for --with-kcp.])
    fi
    AC_MSG_CHECKING([${withval}])
    _KISSME_TEST_CLASSPATH_DIR(${withval})
    if test x$KCP_DIR = x ; then
      AC_MSG_RESULT(no)
      AC_MSG_ERROR([Cannot find the selected Kissme Classpath directory (${withval}).])
    else
      AC_MSG_RESULT(yes)
    fi
  ],
  [
    if test x$KCP_DIR = x ; then
      _KISSME_FIND_CLASSPATH_DIR([kissme_classpath kissme-classpath ../kissme_classpath ../kissme-classpath ${HOME}/kissme_classpath ${HOME}/kissme-classpath ${HOME}/java/kissme_classpath ${HOME}/java/kissme-classpath])
    fi
  ])
  if test x$KCP_DIR != x ; then
    KCP_DIR=`(cd ${KCP_DIR}; pwd)`
    AC_SUBST(KCP_DIR)
    AC_SUBST(KCP,${KCP_DIR})
  fi
])

# Test a list of directories to see if they contain a Kissme Classpath build
AC_DEFUN(_KISSME_FIND_CLASSPATH_DIR, [
  AC_MSG_CHECKING([Kissme Classpath directory])
  for _F in $1 ; do
    _KISSME_TEST_CLASSPATH_DIR(${_F})
    if test x$_KCP_DIR != x ; then
      break
    fi
  done
  if test x${KCP_DIR} = x ; then
    AC_MSG_RESULT([not found])
  else
    AC_MSG_RESULT([${KCP_DIR}])
  fi
])

# Test a directory to see if it is a suitable Kissme Classpath directory.
# kcp_status will be set to depending on whether the
# directory already contains source code or (just) a binary distro.
AC_DEFUN(_KISSME_TEST_CLASSPATH_DIR, [
  if test -d $1 ; then
    KCP_DIR=$1
    if test -f $1/java/lang/Class.java && \
         test -f $1/gnu/classpath/Configuration.java && \
         test -f $1/kissme/vm/loaders/JarClassLoader.java ; then
      kcp_status=source
    elif test -f $1/java/lang/Class.class && \
       test -f $1/gnu/classpath/Configuration.class && \
       test -f $1/kissme/vm/loaders/JarClassLoader.class ; then
      kcp_status=binary
    else
      kcp_status=empty
    fi
  fi 
])

#############################################################################

# Locate the GNU Classpath directory
AC_DEFUN(KISSME_PATH_GNU_CLASSPATH_DIR, [
  AC_ARG_WITH(gnu_classpath, 
  [  --with-gnu-classpath    select GNU Classpath source directory],
  [
    if test "x${withval}" = x ; then
      AC_MSG_ERROR([No value supplied for --with-gnu-classpath.])
    fi
    AC_MSG_CHECKING([${withval}])
    _KISSME_TEST_GNU_CLASSPATH_DIR(${withval})
    if test x$GNU_CLASSPATH_DIR = x ; then
      AC_MSG_RESULT(no)
      AC_MSG_ERROR([Cannot find the selected GNU Classpath source directory (${withval}).])
    else
      AC_MSG_RESULT(yes)
    fi
  ])
  if test x$GNU_CLASSPATH_DIR = x ; then
    _KISSME_FIND_GNU_CLASSPATH_DIR([classpath ../classpath ${HOME}/classpath ${HOME}/java/classpath])
  fi
  if test x$GNU_CLASSPATH_DIR != x ; then
    GNU_CLASSPATH_DIR=`(cd ${GNU_CLASSPATH_DIR}; pwd)`
    AC_SUBST(GNU_CLASSPATH_DIR)
  fi
])

# Test a list of directories to see if they are a GNU Classpath source
# directory
AC_DEFUN(_KISSME_FIND_GNU_CLASSPATH_DIR, [
  AC_MSG_CHECKING([GNU Classpath source directory])
  for _F in $1 ; do
    _KISSME_TEST_GNU_CLASSPATH_DIR(${_F})
    if test x$GNU_CLASSPATH_DIR != x ; then
      break
    fi
  done
  if test x$GNU_CLASSPATH_DIR = x ; then
    AC_MSG_RESULT([not found])
  else
    AC_MSG_RESULT([${GNU_CLASSPATH_DIR}])
  fi
])

# Test a directory to see if it is a GNU Classpath source directory
AC_DEFUN(_KISSME_TEST_GNU_CLASSPATH_DIR, [
  if test -f $1/java/lang/String.java && \
     test -f $1/gnu/classpath/Configuration.java.in && \
     test -f $1/lib/standard.omit ; then
    GNU_CLASSPATH_DIR=$1
  fi 
])

#############################################################################

# Locate the GNU Classpath build directory
AC_DEFUN(KISSME_PATH_GNU_CLASSPATH_BUILD_DIR, [
  AC_ARG_WITH(gnu_classpath_build, 
  [  --with-gnu-classpath-build select GNU Classpath build directory],
  [
    if test "x${withval}" = x ; then
      AC_MSG_ERROR([No value supplied for --with-gnu-classpath-build.])
    fi
    AC_MSG_CHECKING([${withval}])
    _KISSME_TEST_GNU_CLASSPATH_BUILD_DIR(${withval})
    if test x$GNU_CLASSPATH_BUILD_DIR = x ; then
      AC_MSG_RESULT(no)
      AC_MSG_ERROR([Cannot find the selected GNU Classpath build directory (${withval}).])
    else
      AC_MSG_RESULT(yes)
    fi
  ])
  if test x$GNU_CLASSPATH_BUILD_DIR = x ; then
    _KISSME_FIND_GNU_CLASSPATH_BUILD_DIR([${GNU_CLASSPATH_DIR}  classpath ../classpath ${HOME}/classpath ${HOME}/java/classpath])
  fi
  if test x$GNU_CLASSPATH_BUILD_DIR != x ; then
    GNU_CLASSPATH_BUILD_DIR=`(cd ${GNU_CLASSPATH_BUILD_DIR}; pwd)`
    AC_SUBST(GNU_CLASSPATH_BUILD_DIR)
  fi
])

# Test a list of directories to see if they are a GNU Classpath buidl
# directory
AC_DEFUN(_KISSME_FIND_GNU_CLASSPATH_BUILD_DIR, [
  AC_MSG_CHECKING([GNU Classpath build directory])
  for _F in $1 ; do
    _KISSME_TEST_GNU_CLASSPATH_BUILD_DIR(${_F}/build)
    if test x$GNU_CLASSPATH_BUILD_DIR != x ; then
      break
    fi
    _KISSME_TEST_GNU_CLASSPATH_BUILD_DIR(${_F})
    if test x$GNU_CLASSPATH_BUILD_DIR != x ; then
      break
    fi
  done
  if test x$GNU_CLASSPATH_BUILD_DIR = x ; then
    AC_MSG_RESULT([not found])
  else
    AC_MSG_RESULT([${GNU_CLASSPATH_BUILD_DIR}])
  fi
])

# Test a directory to see if it is a GNU Classpath build directory
AC_DEFUN(_KISSME_TEST_GNU_CLASSPATH_BUILD_DIR, [
  if test -f $1/lib/java/lang/String.class && \
     test -f $1/lib/gnu/classpath/Configuration.class && \
     test -d $1/native/jni ; then
    GNU_CLASSPATH_BUILD_DIR=$1
  fi 
])

#############################################################################

# Check that we can find or build the Java classes
AC_DEFUN(KISSME_CHECK_CLASS_BUILD_DEPENDENCIES, [
  AC_REQUIRE([KISSME_PATH_KCP_DIR])
  AC_REQUIRE([KISSME_PATH_GNU_CLASSPATH_DIR])
  AC_REQUIRE([KISSME_PATH_GNU_CLASSPATH_INSTALL_DIR])
  AC_REQUIRE([KISSME_CHECK_USE_KCP])
  if test x${KCP_DIR} = x ; then
    can_merge_kcp=no
    if test ${enable_use_kcp} = yes ; then
      AC_MSG_ERROR([Cannot find a Kissme-Classpath directory.])
    fi
    can_compile_kcp=no
  elif test x${GNU_CLASSPATH_DIR} = x ; then
    can_merge_kcp=no
    if test ${kcp_status} = empty ; then
      if test ${enable_use_kcp} = yes ; then
        AC_MSG_ERROR([Cannot populate the Kissme-Classpath source tree in ${KCP_DIR}: no GNU Classpath build directory could be found.])
      fi
      can_compile_kcp=no
    elif test ${kcp_status} = binary ; then
      if test ${enable_use_kcp} = yes ; then
        AC_MSG_NOTICE([you won't be able to "merge" a Kissme-Classpath source tree.])
      fi
      can_compile_kcp=no
    else
      can_compile_kcp=yes
    fi
  else
    if test ${kcp_status} = empty && \
       test ${enable_use_kcp} = yes ; then
      AC_MSG_NOTICE([the Kissme-Classpath directory (${KCP_DIR}) is currently empty: run "make merge-kcp" to build a source tree.])
    fi
    can_compile_kcp=yes
    can_merge_kcp=yes
  fi
  
  if test x${GLIBJ_ZIP} != x ; then
    have_glibj_zip=yes
  elif test ${enable_use_kcp} = no ; then
    AC_MSG_ERROR([Cannot find the GNU Classpath "glibj.zip" file which is needed to compile and build the Kissme "classes.zip" file.])
  else
    have_glibj_zip=no
  fi
])

#############################################################################

# Set the classpaths for building and running Kissme

AC_DEFUN(KISSME_CLASSPATHS, [
  AC_REQUIRE([KISSME_PATH_KCP_DIR])
  AC_REQUIRE([KISSME_CHECK_CLASS_BUILD_DEPENDENCIES])
  AC_REQUIRE([KISSME_CHECK_USE_KCP])
  AC_REQUIRE([KISSME_CHECK_USE_ZIPS])
  ABS_HERE=`pwd`
  if test $enable_use_kcp = yes ; then
    if test $enable_use_zips = yes ; then
      KISSME_CLASSPATH=$ABS_HERE/kcp.zip
    else
      KISSME_CLASSPATH=$KCP_DIR
    fi
  else
    if test $enable_use_zips != yes ; then
      AC_MSG_ERROR([HUH!? Shouldn't get here])
    fi
    KISSME_BUILD_CLASSPATH=$ABS_HERE/classes:$GLIBJ_ZIP
    KISSME_CLASSPATH=$ABS_HERE/classes.zip:$GLIBJ_ZIP
    AC_SUBST(KISSME_BUILD_CLASSPATH)
  fi

  KCP_BUILD_CLASSPATH=$KCP_DIR
  AC_SUBST(KCP_BUILD_CLASSPATH)
  AC_SUBST(KISSME_CLASSPATH)
])

#############################################################################

# Locate the (optional) directory containing the Mauve test suite
AC_DEFUN(KISSME_PATH_MAUVE_DIR, [
  AC_ARG_WITH(mauve, 
  [  --with-mauve            select optional Mauve (test harness) directory],
  [
    if test "x${withval}" = x ; then
      AC_MSG_ERROR([No value supplied for --with-mauve.])
    fi
    AC_MSG_CHECKING([${withval}])
    _KISSME_TEST_MAUVE_DIR(${withval})
    if test x$MAUVE_DIR = x ; then
      AC_MSG_RESULT(no)
      AC_MSG_ERROR([Cannot find the selected Mauve directory (${withval}).])
    else
      AC_MSG_RESULT(yes)
    fi
  ])
  if test x$MAUVE_DIR = x ; then
    _KISSME_FIND_MAUVE_DIR([mauve ../mauve ${HOME}/mauve ${HOME}/java/mauve])
  fi
  if test x$MAUVE_DIR != x ; then
    MAUVE_DIR=`(cd ${MAUVE_DIR}; pwd)`
  fi
  AC_SUBST(MAUVE_DIR)  
  AC_SUBST(MAUVE_CLASSPATH, ${MAUVE_DIR})
])

# Test a list of directories to see if they are a Mauve directory
AC_DEFUN(_KISSME_FIND_MAUVE_DIR, [
  AC_MSG_CHECKING([Mauve test harness])
  for _F in $1 ; do
    _KISSME_TEST_MAUVE_DIR(${_F})
    if test x$MAUVE_DIR != x ; then
      break
    fi
  done
  if test x$MAUVE_DIR = x ; then
    AC_MSG_RESULT([not found])
  else
    AC_MSG_RESULT([${MAUVE_DIR}])
  fi
])

# Test a directory to see if it is a GNU Classpath source / build directory
AC_DEFUN(_KISSME_TEST_MAUVE_DIR, [
  if test -f $1/gnu/testlet/SimpleTestHarness.java || \
     test -f $1/gnu/testlet/SimpleTestHarness.class ; then
    MAUVE_DIR=$1
  fi 
])


#############################################################################

# Locate a Classpath installation directory
AC_DEFUN(KISSME_PATH_GNU_CLASSPATH_INSTALL_DIR, [
  AC_ARG_WITH(classpath_install_dir, 
  [  --with-classpath-install-dir select the GNU Classpath install directory],
  [
    if test "x${withval}" = x ; then
      AC_MSG_ERROR([No value supplied for --with-classpath-install-dir.])
    fi
    AC_MSG_CHECKING([${withval}])
    _KISSME_TEST_GNU_CLASSPATH_INSTALL_DIR(${withval})
    if test x$GNU_CLASSPATH_INSTALL_DIR = x ; then
      AC_MSG_RESULT(no)
      AC_MSG_ERROR([Cannot find the selected GNU Classpath installation.])
    else
      AC_MSG_RESULT(yes)
    fi
  ],
  [
    if test x$GNU_CLASSPATH_INSTALL_DIR = x ; then
      _KISSME_FIND_GNU_CLASSPATH_INSTALL_DIR([/usr/local/classpath /usr/local /usr /opt/classpath])
      if test x$GNU_CLASSPATH_INSTALL_DIR = x ; then
        AC_MSG_ERROR([Cannot find a GNU Classpath installation: install it and/or specify its location using --with-classpath-install-dir.])
      fi
    fi
  ])
  GNU_CLASSPATH_INSTALL_DIR=`(cd ${GNU_CLASSPATH_INSTALL_DIR}; pwd)`
  AC_SUBST(GNU_CLASSPATH_INSTALL_DIR)
  if test -r ${GNU_CLASSPATH_INSTALL_DIR}/share/classpath/glibj.zip ; then
    GLIBJ_ZIP=${GNU_CLASSPATH_INSTALL_DIR}/share/classpath/glibj.zip
    AC_SUBST(GLIBJ_ZIP)
  fi
])

# Test a list of directories to see if they contain a Classpath installation
AC_DEFUN(_KISSME_FIND_GNU_CLASSPATH_INSTALL_DIR, [
  AC_MSG_CHECKING([GNU Classpath installation directory])
  for _F in $1 ; do
    _KISSME_TEST_GNU_CLASSPATH_INSTALL_DIR(${_F})
    if test x$GNU_CLASSPATH_INSTALL_DIR != x ; then
      break
    fi
  done
  if test x${GNU_CLASSPATH_INSTALL_DIR} = x ; then
    AC_MSG_RESULT([not found])
  else
    AC_MSG_RESULT([${GNU_CLASSPATH_INSTALL_DIR}])
  fi
])

# Test a directory to see if it contains a Classpath installation.
AC_DEFUN(_KISSME_TEST_GNU_CLASSPATH_INSTALL_DIR, [
  if test -r $1/lib/classpath/libjavalang.so && \
     test -r $1/share/classpath/glibj.zip ; then
    GNU_CLASSPATH_INSTALL_DIR=$1
  fi 
])

#############################################################################

# Find out if Kissme should boot from a ZIP file
AC_DEFUN(KISSME_CHECK_USE_ZIPS,
[
  AC_REQUIRE([KISSME_PATH_ZIP])
  AC_REQUIRE([KISSME_PATH_KCP_DIR])
  AC_ARG_ENABLE(use_zips, 
  [  --enable-use-zips       use ZIP file(s) for bootstrapping the VM])
  AC_MSG_CHECKING([whether to use ZIP files for bootstrapping the Kissme VM])
  if test x$enable_use_zips = xyes ; then
    if test x$ZIP = x ; then
      AC_MSG_RESULT(whoops)
      AC_MSG_ERROR([Cannot honour --enable-use-zips: cannot find a zip utility.]) 
    fi
  elif test x$enable_use_zips = xno ; then
    if test x$KCP_DIR = x ; then
      AC_MSG_RESULT(whoops)
      AC_MSG_ERROR([Cannot honour --disable-use-zips: cannot find a Kissme-Classpath directory.]) 
    fi
  else
    if test x$ZIP = x ; then
      enable_use_zips=no
    else
      enable_use_zips=yes
    fi
  fi
  AC_MSG_RESULT($enable_use_zips)
])

#############################################################################

# Find out if Kissme should boot from a KCP assembly
AC_DEFUN(KISSME_CHECK_USE_KCP,
[
  AC_REQUIRE([KISSME_PATH_KCP_DIR])
  AC_REQUIRE([KISSME_CHECK_USE_ZIPS])
  AC_REQUIRE([KISSME_PATH_GNU_CLASSPATH_INSTALL_DIR])
  AC_ARG_ENABLE(use_kcp, 
  [  --enable-use-kcp        use a Kissme-Classpath for bootstrapping the VM])
  AC_MSG_CHECKING([whether to use Kissme-Classpath for bootstrapping the Kissme VM])
  if test x$enable_use_kcp = xyes ; then
    if test x$KCP_DIR = x ; then
      AC_MSG_RESULT(whoops)
      AC_MSG_ERROR([Cannot honour --enable-use-kcp: cannot find a Kissme-Classpath directory.]) 
    fi
  elif test x$enable_use_kcp = xno ; then
    if test x$GLIBJ_ZIP = x ; then
      AC_MSG_RESULT(whoops)
      AC_MSG_ERROR([Cannot honour --disable-use-kcp: cannot find "glibj.zip".]) 
    fi
  else
    if test x$GLIBJ_ZIP = x || \
       test x$enable_use_zips = xno ; then
      enable_use_kcp=yes
    else
      enable_use_kcp=no
    fi
  fi
  AC_MSG_RESULT($enable_use_kcp)
])
