# - Try to find FindBeagle
# Once done this will define
#
#  BEAGLE_FOUND - system has FindBeagle
#  BEAGLE_INCLUDE_DIR - the FindBeagle include directory
#  BEAGLE_LIBRARIES - Link these to use FindBeagle
#  BEAGLE_DEFINITIONS - Compiler switches required for using FindBeagle
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.
#


if ( BEAGLE_INCLUDE_DIR AND BEAGLE_LIBRARIES )
   # in cache already
   SET(Beagle_FIND_QUIETLY TRUE)
endif ( BEAGLE_INCLUDE_DIR AND BEAGLE_LIBRARIES )

# use pkg-config to get the directories and then use these values
# in the FIND_PATH() and FIND_LIBRARY() calls
if( NOT WIN32 )
  INCLUDE(UsePkgConfig)

  PKGCONFIG(libbeagle-1.0 _BeagleIncDir _BeagleLinkDir _BeagleLinkFlags _BeagleCflags)

  SET(BEAGLE_DEFINITIONS ${_BeagleCflags})
  SET(BEAGLE_LINK_FLAGS ${_BeagleLinkFlags})
endif( NOT WIN32 )

FIND_PATH(BEAGLE_INCLUDE_DIR NAMES beagle/beagle.h
  PATHS
  ${_BeagleIncDir}
  PATH_SUFFIXES libbeagle
  NO_DEFAULT_PATH
)

FIND_LIBRARY(BEAGLE_LIBRARIES NAMES beagle
  PATHS
  ${_BeagleLinkDir}
  NO_DEFAULT_PATH
)

include(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(FindBeagle DEFAULT_MSG BEAGLE_INCLUDE_DIR BEAGLE_LIBRARIES )

# show the BEAGLE_INCLUDE_DIR and BEAGLE_LIBRARIES variables only in the advanced view
MARK_AS_ADVANCED(BEAGLE_INCLUDE_DIR BEAGLE_LIBRARIES )

