#!/bin/sh

function usage
{
	# Title
	echo "Title: rawplay playback"

	# Usable?
	which rawplay > /dev/null
	[ $? = 0 ] && echo Status: Active || echo Status: Inactive

	# Type
	echo Flags: single-pass 

	# Profiles
	echo Profile: Full Screen, OSS audio output
	echo Profile: Full Screen, ARTS audio output
	echo Profile: Full Screen, ESD audio output
	echo Profile: Windowed, OSS audio output
	echo Profile: Windowed, ARTS audio output
	echo Profile: Windowed, ESD audio output
}

function execute
{
	# Arguments
	normalisation="$1"
	length="$2"
	profile="$3"

	# Run the command
	case "$profile" in 
		"0" ) 	rawplay -b -f -ao dsp ;;
		"1" ) 	rawplay -b -f -ao artsc ;;
		"2" ) 	rawplay -b -f -ao esd ;;
		"3" ) 	rawplay -b -ao dsp ;;
		"4" ) 	rawplay -b -ao artsc ;;
		"5" ) 	rawplay -b -ao esd ;;
	esac
}

[ "$1" = "--usage" -o "$1" = "" ] && usage $@ || execute $@
