/*
 * VideoScreen is a QWidget for Play
 * Copyright (C) 2002 Tim Jansen <tim@tjansen.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef KDE_GSTPLAY_VIDEOSCREEN_H
#define KDE_GSTPLAY_VIDEOSCREEN_H

#include <qwidget.h>

#include <kde/gstplay/play.h>

namespace KDE {
namespace GSTPlay {
	class VideoScreenPrivate;
	
/**
 * This widget can be attached to a @ref Play object to display the video. 
 * You can have only one VideoScreen per Play object.
 * @ref Play
 */
	class VideoScreen : public QWidget 
	{
		Q_OBJECT

		VideoScreenPrivate *d;
	public:
/**
 * Creates a new VideoScreen.
 * @param player the player to attach to
 * @param parent the widget's parent
 * @param name the name of the widget
 */		
		VideoScreen(Play *player, QWidget *parent=0, const char *name=0);
		~VideoScreen();

/**
 * Returns the size of the video. The returned size is invalid if the
 * size is not known.
 * @return the size of the video, or an invalid size if not known yet
 * @see Play::haveVideoSize()
 */
		QSize videoSize() const;

	private slots:
		void haveXId(int xid);
		void haveVideoSize(int w, int h);
	};
}
}

#endif
