/*
 *  Interface/wrapper for GStreamer system functions
 *  Copyright (C) 2002 Tim Jansen <tim@tjansen.de>
 *  API Documentation
 *  Copyright (C) 1999,2000 Erik Walthinsen <omega@cse.ogi.edu>
 *                     2000 Wim Taymans <wtay@chello.be>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "gstreamer.h"
#include "helper.h"
#include "wrapper.h"
#include "clock.h"
#include "pipeline.h"
#include "pad.h"
#include "padtemplate.h"
#include "elementfactory.h"
#include "autoplug.h"
#include "thread.h"
#include "dp/dparammanager.h"
#include "dp/dparamsmooth.h"

extern "C" {
#include <gst/gst.h>
#include <gst/control/control.h>
}

using namespace KDE::GST;


bool GStreamer::m_isInitialized = false;

void GStreamer::init(int *argc, char **argv[]) {
	if (m_isInitialized)
		return;
	m_isInitialized = true;
	gst_init(argc, argv);
	gst_control_init(argc,argv);

	/* Register factory functions */
	Wrapper::registerType(QString("GObject"),
			      Wrapper::wrapperFactory);
	Wrapper::registerType(QString("GstObject"),
			      Object::wrapperFactory);
	Wrapper::registerType(QString("GstElement"),
	                      Element::wrapperFactory);
	Wrapper::registerType(QString("GstClock"),
			     Clock::wrapperFactory);
	Wrapper::registerType(QString("GstElementFactory"),
			     ElementFactory::wrapperFactory);
	Wrapper::registerType(QString("GstBin"),
			     Bin::wrapperFactory);
	Wrapper::registerType(QString("GstPipeline"),
			     Pipeline::wrapperFactory);
	Wrapper::registerType(QString("GstThread"),
			     Thread::wrapperFactory);
	Wrapper::registerType(QString("GstAutoplug"),
			     Autoplug::wrapperFactory);
	Wrapper::registerType(QString("GstPad"),
			     Pad::wrapperFactory);
	Wrapper::registerType(QString("GstPadTemplate"),
			     PadTemplate::wrapperFactory);
	Wrapper::registerType(QString("GstDParamManager"),
			     KDE::GST::DP::DParamManager::wrapperFactory);
	Wrapper::registerType(QString("GstDParam"),
			     KDE::GST::DP::DParam::wrapperFactory);
	Wrapper::registerType(QString("GstDParamSmooth"),
			     KDE::GST::DP::DParamSmooth::wrapperFactory);
}

void GStreamer::version(unsigned int *major,
			unsigned int *minor,
			unsigned int *micro) {
	gst_version(major, minor, micro);
}

void GStreamer::main() {
	gst_main();
}

void GStreamer::mainQuit() {
	gst_main_quit();
}

void GStreamer::useThreads(bool useThreads) {
	gst_use_threads(useThreads ? TRUE : FALSE);
}

bool GStreamer::hasThreads() {
	return CONVERT_GBOOL(gst_has_threads());
}
