/*
 *  Interface/wrapper for GStreamer GstClock
 *  Copyright (C) 2002 Tim Jansen <tim@tjansen.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "clock.h"
#include "helper.h"

extern "C" {
#include <gst/gst.h>
}

using namespace KDE::GST;

#define r() GST_CLOCK(m_real)

// helper factory function for classMap. See used in gstreamer.cpp
Wrapper* Clock::wrapperFactory(void *real) {
	return new Clock(real);
}

Clock::Clock(void *real) :
	Object(real) {
}

Clock::~Clock() {
}

Clock* Clock::wrap(void *real) {
	return (Clock*) Object::wrap(real);
}

void Clock::setSpeed(double speed) {
	gst_clock_set_speed(r(), speed);
}

double Clock::getSpeed() {
	return gst_clock_get_speed(r());
}

void Clock::setActive(bool active) {
	gst_clock_set_active(r(), CONVERT_GBOOL(active));
}

bool Clock::isActive() {
	return gst_clock_is_active(r());
}

void Clock::reset() {
	gst_clock_reset(r());
}

bool Clock::handleDiscont(long long time) {
	return gst_clock_handle_discont(r(), time);
}

long long Clock::getTime() {
	return gst_clock_get_time(r());
}

void Clock::setResolution(long long resolution) {
	gst_clock_set_resolution(r(), resolution);
}

long long Clock::getResolution() {
	return gst_clock_get_resolution(r());
}

Clock::ID Clock::getNextId() {
	return (ID) gst_clock_get_next_id(r());
}

Clock::ID Clock::newSingleShotId(unsigned long long time) {
	return (ID) gst_clock_new_single_shot_id(r(), time);
}

Clock::ID Clock::newPeriodicId(unsigned long long startTime,
			unsigned long long interval) {
	return (ID) gst_clock_new_periodic_id(r(), 
					      startTime,
					      interval);
}

unsigned long long Clock::idGetTime(Clock::ID id) {
	return gst_clock_id_get_time((GstClockID) id);
}

Clock::ClockReturn Clock::idWait(Clock::ID id, long long *jitter) {
	return (ClockReturn) gst_clock_id_wait((GstClockID) id, jitter);
}

void Clock::idUnschedule(Clock::ID id) {
	gst_clock_id_unschedule((GstClockID) id);
}

void Clock::idUnlock(Clock::ID id) {
	gst_clock_id_unlock((GstClockID) id);
}

void Clock::idFree(Clock::ID id) {
	gst_clock_id_free((GstClockID) id);
}


#include "clock.moc"

