/*
 * Multi-threaded GUI player for audio+video. 
 * Demonstrates Qt event loop integration
 * and seeking.
 * Based on spider_seek.c example from gst-plugins.
 */

#ifndef GUIPLAYER_H
#define GUIPLAYER_H

#include <qtimer.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <qlayout.h>
#include <qapplication.h>
#include <qxembed.h>

#include <kde/gstplay/play.h>
#include <kde/gstplay/videoscreen.h>

using KDE::GSTPlay;

class GuiPlayer : public QWidget 
{
	Q_OBJECT

	QApplication *m_app;
	QSlider *m_slider;
	KDE::GSTPlay::VideoScreen *m_videoScreen;

	QPushButton *m_playButton;
	QPushButton *m_pauseButton;
	QPushButton *m_stopButton;

	KDE::GSTPlay::Play *m_player;
	unsigned long long m_duration;

public:
	GuiPlayer(QApplication*,const QString &filename);
	~GuiPlayer();

private slots:
	void play();
	void pause();
	void stop();
	void seek();
	void updateSlider(long long timeNs);
	void haveSize(int width, int height);
	void setLength(long long d);
};

#endif
