\ nigpib.4th
\
\ kForth interface words for the Linux version of the GPIB 
\ driver developed by National Instruments, which can be found
\ at the National Instruments website (www.ni.com).
\
\ Copyright (c) 2000 David P. Wallace and Krishna Myneni
\
\ Provided under the terms of the GNU General Public License
\
\ Revisions:
\ 
\   3-09-2000  modified the kForth interface to the Linux GPIB driver 
\	         (gpib.4th) to work with the National Instr. driver
\   6-17-2004  added 1 ms delays in send_command and send_bytes
\                after discovering failure to communicate with some
\                devices. km		   
\   6-25-2004  added 1 ms delays in read_bytes -- fixed problems
\                with a GPIB device with which I could not previously
\                communicate. km


variable gpib_driver
c" /dev/gpib" gpib_driver ! 

12 constant C_IBCMD
16 constant C_IBRPP
18 constant C_IBWAIT
19 constant C_IBONL
21 constant C_IBGTS
22 constant C_IBCAC
25 constant C_IBSRE
27 constant C_IBRD
28 constant C_IBWRT
31 constant C_IBSIC
35 constant C_IBEOT
38 constant C_IBDMA
39 constant C_IBEOS
40 constant C_IBTMO
46 constant C_IBDEV



variable gpib_fd

create ibargs 11 4 * allot

0 constant OF_SIZE
4 constant OF_HANDLE
8 constant OF_IB_IBSTA
12 constant OF_IB_IBERR
16 constant OF_IB_IBCNTL
20 constant OF_IB_BUF
24 constant OF_IB_BUF1
28 constant OF_IB_BUF2
32 constant OF_IB_N
36 constant OF_IB_N1
40 constant OF_IB_N2

create ibcmd_buf 64 allot
create ibdev_info 6 cells allot
create gpib_in_buf 16384 allot
create gpib_out_buf 16384 allot
create gpib_buf1 64 allot
create gpib_buf2 64 allot

44 ibargs OF_SIZE + !
0 ibargs OF_IB_N2 + !
gpib_buf1 ibargs OF_IB_BUF1 + !
gpib_buf2 ibargs OF_IB_BUF2 + !

: open_gpib ( -- ior | open the gpib device driver )
	gpib_driver a@ 2 open dup gpib_fd ! 0 < 
	0 ibargs OF_HANDLE + ! ;

: close_gpib ( -- | close the device driver )
	gpib_fd @ close drop ;

: ibsta ( -- status | return status of last gpib function )
	ibargs OF_IB_IBSTA + @ ;

: iberr ( -- error | return error code of last gpib function )
	ibargs OF_IB_IBERR + @ ;

: ibcnt ( -- count | return count from last gpib function )
	ibargs OF_IB_IBCNTL + @ ;

: ibonl ( onl -- | place the gpib online/offline )
	ibargs OF_IB_N + !
	gpib_fd @ C_IBONL ibargs ioctl drop ;

: ibsic ( -- | send interface clear on gpib0 )
	gpib_fd @ C_IBSIC ibargs ioctl drop ;

: ibsre ( v -- | set or clear remote enable line )
	ibargs OF_IB_N + !
	gpib_fd @ C_IBSRE ibargs ioctl drop ;

: ibtmo ( v -- | set timeout to v )
	\ v: 0 = disabled, 1 = 10 usec, 2 = 30 usec, 3 = 100 usec,
	\    4 = 300 usec, 5 = 1 msec, 6 = 3 msec, 7 = 10 msec,
	\    8 = 30 msec, 9 = 100 msec, 10 = 300 msec, 11 = 1 sec,
	\    12 = 3 sec, 13 = 10 sec, 14 = 30 sec, 15 = 100 sec
	ibargs OF_IB_N + !
	gpib_fd @ C_IBTMO ibargs ioctl drop ;

: ibdma ( v -- | set dma )
	\ v: 0 = disabled, non zero = enable
	ibargs OF_IB_N + !
	gpib_fd @ C_IBDMA ibargs ioctl drop ;

: ibdev (  -- | set dev )
	0 ibdev_info !
	0 ibdev_info 4 + !
	0 ibdev_info 8 + !
	13 ibdev_info 12 + !
	1 ibdev_info 16 + !
	0 ibdev_info 20 + !
	6 cells ibargs OF_IB_N + !
	ibdev_info ibargs OF_IB_BUF + !
	gpib_fd @ C_IBDEV ibargs ioctl drop ;


: init_gpib ( -- | initialize the gpib board and interface )
	1 ibonl
	ibsic
	1 ibsre ;
	\ 12 ibtmo ;

: ibcmd ( c_n ... c_2 c_1 n -- ibsta | send command bytes to gpib )
	dup ibargs OF_IB_N + !
  	0 do ibcmd_buf i + c! loop
	ibcmd_buf ibargs OF_IB_BUF + !
	\ 0 ibargs OF_IB_N + !
	gpib_fd @ C_IBCMD ibargs ioctl drop ibsta ;

: clear_device ( n -- | send SDC to device at address n )
	4 swap 32 + 64 3 ibcmd drop ;


: ibrd2 ( buf n -- | read n bytes into buf )
	ibargs OF_IB_N + !
	ibargs OF_IB_BUF + !
	gpib_fd @ C_IBRD ibargs ioctl drop ;

: ibwrt2 ( buf n -- | write n bytes from buf )
	ibargs OF_IB_N + !
	ibargs OF_IB_BUF + !
	gpib_fd @ C_IBWRT ibargs ioctl drop ;



: send_command ( addr n  -- | send byte sequence to dev n )     
   \ addr is the address of a counted string containing         
   \ the byte sequence.                                         
   \ n is the primary address of the device
                                                
    32 + 64 2 ibcmd drop      \ set talker and listener
    1 ms         
    count ibwrt2              \ write data
    1 ms                      
    95 63 2 ibcmd drop ;      \ untalk and unlisten             


: send_bytes ( m n -- | send m bytes to device n )              
                                                                
    \ This word is similar to send_command except that          
    \ it operates on the output buffer gpib_out_buf            
    \ rather than a counted string.                             
    \ m is the number of bytes to send from gpib_out_buf.      
    \ n is the primary address of the device.                   
                                                                
    32 + 64 2 ibcmd drop       \ set talker and listener
    1 ms        
    gpib_out_buf swap ibwrt2  \ write data
    1 ms                     
    95 63 2 ibcmd drop ;       \ untalk and unlisten       


: read_bytes ( m n -- | read m bytes from dev n )               
    \ n is the primary address of the device                    
    \ m bytes are stored in gpib_in_buf                        
                                                                
    64 + 32 2 ibcmd drop       \ set listener and talker        
    1 ms
    gpib_in_buf swap ibrd2     \ read data                      
    1 ms
    63 95 2 ibcmd drop ;       \ untalk and unlisten            



\ ***************

: ibeot ( n -- | enable/disable auto EOI line assertion )
	\ n = 0 disable EOI assertion
	\ n = non-zero enable EOI assertion
	ibargs OF_IB_N + !
	gpib_fd @ C_IBEOT ibargs ioctl drop ;

: ibeos ( n -- | enable/set EOS termination character )
	\ n = 0 disable EOS Mode
	\ n = non-zero set the EOS charater and Mode
	\     the upper byte sets the mode and the lower
	\     byte is the end-of-string character.
	ibargs OF_IB_N + !
	gpib_fd @ C_IBEOS ibargs ioctl drop ;
	

: status base @ ibsta 16 binary .R base ! cr iberr . ;
