#!/bin/sh -x

newfiles()
{
    for file in `find  new-files-archive  -type f`
    do
      mv $file $file.new
      touch $file
      diff -u $file $file.new > $file.patch
      rm -f $file
      mv $file.new $file
    done
}

removedfiles()
{
    for file in `find removed-files-archive -type f`
    do
      diff -u $file /dev/null > $file.patch
    done
}

cleanup()
{
    for file in `find new-files-archive removed-files-archive -type f -name '*.patch'`
    do
      rm -f $file
    done
}

genpatch()
{
    rm -f $patch
    touch $patch
    for file in `find new-files-archive removed-files-archive patches -type f -name '*.patch'|grep -v '{arch}'|grep -v '.arch-ids'`
    do
      cat $file >> $patch
    done
}

newfiles
removedfiles
export patch="$1"
genpatch
cleanup
    