/***************************************************************************
                          sun.h  -  Sun Rise and Set Calculations
                             -------------------
    begin                : Friday July 11 2003
    copyright            : (C) 2003 by John Ratke
    email                : jratke@comcast.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SUN_H
#define SUN_H

#include <qobject.h>
#include <qstring.h>
#include <qdatetime.h>
#include <krfcdate.h>

class Sun : public QObject
{
	Q_OBJECT
	
	public:
		Sun(QDate date = QDate::currentDate());
		
		QTime computeRiseTime(const QString &latitude, const QString &longitude, const int localUTCOffset = KRFCDate::localUTCOffset());
		QTime computeSetTime(const QString &latitude, const QString &longitude, const int localUTCOffset = KRFCDate::localUTCOffset());

	private:
		double latitudeToDouble(const QString &latitude);
		double longitudeToDouble(const QString &longitude);
		
		void convertDoubleToHMS(const double time, int &hours, int &minutes, int &seconds);
		void adjustToLocalTime(const int localUTCOffset, int &hours, int &minutes);
		
		int __sunriset__( int year, int month, int day, 
			          double lon, double lat,
			          double altit, int upper_limb, 
			          double *trise, double *tset);
		
		void sunpos( double d, double *lon, double *r );

		void sun_RA_dec( double d, double *RA, double *dec, double *r );

		double revolution( double x );

		double rev180( double x );

		double GMST0( double d );

		QDate m_Date;
};

#endif
