/*                                                                      
    This file is part of KWeather.                                  
    Copyright (c) 2003 Tobias Koenig <tokoe@kde.org>
                                                                        
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or   
    (at your option) any later version.                                 
                                                                        
    This program is distributed in the hope that it will be useful,     
    but WITHOUT ANY WARRANTY; without even the implied warranty of      
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the        
    GNU General Public License for more details.                        
                                                                        
    You should have received a copy of the GNU General Public License   
    along with this program; if not, write to the Free Software         
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.           
                                                                        
    As a special exception, permission is given to link this program    
    with any edition of Qt, and distribute the resulting executable,    
    without including the source code for Qt in the source distribution.
*/                                                                      

#include <qimage.h>
#include <qlayout.h>
#include <qpushbutton.h>

#include <dcopclient.h>
#include <dcopref.h>
#include <kaboutdata.h>
#include <kapplication.h>
#include <kdebug.h>
#include <klineedit.h>
#include <klistbox.h>
#include <klocale.h>
#include <kpushbutton.h>

#include "serviceconfigdata.h"

#include "kcmweatherservice.h"

extern "C"
{
  KCModule *create_weatherservice( QWidget *parent, const char * ) {
    return new KCMWeatherService( parent, "kweather" );
  }
}

KCMWeatherService::KCMWeatherService( QWidget *parent, const char *name )
  : KCModule( parent, name )
{
  QVBoxLayout *layout = new QVBoxLayout( this );
  mWidget  = new wsPrefs( this );
  layout->addWidget( mWidget );

	connect( mWidget->add, SIGNAL( released() ), SLOT( addStation() ) );
	connect( mWidget->remove, SIGNAL( released() ), SLOT( removeStation() ) );

	connect( mWidget->update, SIGNAL( released() ), SLOT( updateStations() ) );
	connect( mWidget->exit, SIGNAL( released() ), SLOT( exitWeatherService() ) );

	scanStations();
}

void KCMWeatherService::show()
{
  scanStations();
  KCModule::show();
}

void KCMWeatherService::addStation()
{
	if ( dcopActive() )
	{
		DCOPRef service( "KWeatherService", "WeatherService" );
		service.call( "addStation(QString )", mWidget->station->text() );
		mWidget->station->clear();
		scanStations();
	}
}

void KCMWeatherService::removeStation()
{
	if ( dcopActive() )
	{
		DCOPRef service( "KWeatherService", "WeatherService" );
		service.call( "removeStation(QString)", mWidget->stationList->currentText() );
		scanStations();
	}
}

void KCMWeatherService::updateStations()
{
	if ( dcopActive() )
	{
		DCOPRef service( "KWeatherService", "WeatherService" );
		service.call( "updateAll()" );
		scanStations();
	}
}

void KCMWeatherService::exitWeatherService()
{
	if ( dcopActive() )
	{
		DCOPRef service( "KWeatherService", "WeatherService" );
		service.call( "exit()" );
	}
}

void KCMWeatherService::scanStations()
{
	if ( dcopActive() )
	{
		DCOPRef service( "KWeatherService", "WeatherService" );
		QStringList lst = service.call( "listStations()" );
		mWidget->stationList->clear();
		for( uint idx = 0; idx < lst.size(); idx++ )
		{
			QPixmap pix = service.call( "icon(QString)", lst[ idx ] );
			QImage img = pix.convertToImage();
			img = img.smoothScale( 22, 22 );
			pix.convertFromImage( img );
			mWidget->stationList->insertItem( pix, lst[ idx ] );
		}
	}
}

bool KCMWeatherService::dcopActive()
{
	QString error;
	QCString appID;
	bool isGood = true;
	DCOPClient *client = kapp->dcopClient();
	kdDebug( 12004 ) << "Looking for dcop service..." << endl;
	if ( !client->isApplicationRegistered( "KWeatherService" ) )
	{
		kdDebug( 12004 ) << "Could not find service so I am starting it..." << endl;
		if( KApplication::startServiceByDesktopName( "kweatherservice", QStringList(), &error, &appID ) )
		{
			kdDebug( 12004 ) << "Starting dcopservice failed with message: " << error << endl;
			isGood = false;
		}
	}

	return isGood;
}

void KCMWeatherService::load()
{
}

void KCMWeatherService::save()
{
}

void KCMWeatherService::defaults()
{
}

const KAboutData* KCMWeatherService::aboutData() const
{
  KAboutData *about = new KAboutData( "kcmweatherservice",
                                      I18N_NOOP( "KWeather Configure Dialog" ),
                                      0, 0, KAboutData::License_GPL,
                                      I18N_NOOP( "(c), 2003 Tobias Koenig" ) );

  about->addAuthor( "Tobias Koenig", 0, "tokoe@kde.org" );

  return about;
}

#include "kcmweatherservice.moc"
