/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include "pwmviewstyle_0.h"
#include "pwmview.h"
#include "listviewpwm.h"
#include "commentbox.h"

#include <klocale.h>


PwMViewStyle_0::PwMViewStyle_0(PwMView *view)
 : QObject()
{
	vbox1 = new QVBox(view);
	vbox1->setSpacing(3);
	hbox1 = new QHBox(vbox1);
	hbox1->setSpacing(10);
	categoriesTitle = new QLabel(hbox1);
	categoriesTitle->setText(i18n("Categories:"));
	categoriesCombo = new QComboBox(hbox1);
	renCatButton = new QPushButton(i18n("&Rename"), hbox1);
	delCatButton = new QPushButton(i18n("&Delete"), hbox1);
	splitter1 = new QSplitter(vbox1);
	splitter1->setOrientation(Qt::Vertical);
	lv = new ListViewPwM(splitter1);
	commentBox = new CommentBox(splitter1);
	// set sizes and styles
	commentBox->resize(commentBox->size().width(), 60);
	categoriesTitle->setAlignment(Qt::AlignVCenter | Qt::AlignRight);
	// connections
	connect(categoriesCombo, SIGNAL(activated(int)),
		view, SLOT(shiftToView()));
	connect(renCatButton, SIGNAL(clicked()),
		view, SLOT(renCatButton_slot()));
	connect(delCatButton, SIGNAL(clicked()),
		view, SLOT(delCatButton_slot()));
}

PwMViewStyle_0::~PwMViewStyle_0()
{
	delete commentBox;
	delete vbox1;
}

void PwMViewStyle_0::delCategory(const QString &cat)
{
	PWM_ASSERT(categoriesCombo);
	int i, count = categoriesCombo->count();
	for (i = 0; i < count; ++i) {
		if (categoriesCombo->text(i) == cat) {
			categoriesCombo->removeItem(i);
			return;
		}
	}
	BUG();
}

void PwMViewStyle_0::selectCategory(const QString &cat)
{
	PWM_ASSERT(categoriesCombo);
	int i, count = categoriesCombo->count();
	for (i = 0; i < count; ++i) {
		if (categoriesCombo->text(i) == cat) {
			categoriesCombo->setCurrentItem(i);
			return;
		}
	}
	// fall back to 0
	categoriesCombo->setCurrentItem(0);
}
