/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include "pwgenwndimpl.h"
#include "pwmexception.h"
#include "genpasswd.h"
#include "genpasswd_extern.h"
#include "configuration.h"

#include <qtabwidget.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qradiobutton.h>
#include <qprogressbar.h>

#include <klocale.h>
#include <kmessagebox.h>


PwGenWndImpl::PwGenWndImpl(QWidget *parent,
			   const char *name,
			   bool modal,
			   WFlags fl)
 : pwGenWnd(parent, name, modal, fl)
{
//	ext_cmdLineEdit->setText(conf()->confGlobExtGenerator());
	updateQualityBar_slot();
}

PwGenWndImpl::~PwGenWndImpl()
{
}

void PwGenWndImpl::genButton_slot()
{
	switch (mainTab->currentPageIndex()) {
		case 0:
			// internal generator
			if (!optionsSanityIntGen())
				return;
			if (startIntGen())
				goto exit_success;
			break;
		case 1:
			// external generator
			if (!optionsSanityExtGen())
				return;
			if (startExtGen()) {
//				conf()->confGlobExtGenerator(ext_cmdLineEdit->text());
				goto exit_success;
			}
			break;
		default:
			BUG();
	}
	done(0);
	return;
exit_success:
	done(1);
}

void PwGenWndImpl::cancelButton_slot()
{
	done(0);
}

bool PwGenWndImpl::optionsSanityIntGen()
{
	if (int_pronounceableCheckBox->isChecked())
		return true;
	if (int_charLowerCheckBox->isChecked())
		return true;
	if (int_charUpperCheckBox->isChecked())
		return true;
	if (int_charNumCheckBox->isChecked())
		return true;
	if (int_charSpecCheckBox->isChecked())
		return true;
	if (int_charUserCheckBox->isChecked()) {
		if (int_userDefLineEdit->text().length() >= 2)
			return true;
		if (int_charBlankCheckBox->isChecked())
			return true;
	}
	KMessageBox::error(this,
			   i18n("Incorrect Charset selection.\n"
			        "It is impossible to generate a sane "
			        "password with the selected charset(s).\n"
			        "Please select more charsets."),
			   i18n("Incorrect Charset Selection"));
	return false;
}

bool PwGenWndImpl::startIntGen()
{
	GenPasswd gen;
	gen.setLen(int_lenSpinBox->value());
	if (int_pronounceableCheckBox->isChecked())
		gen.setMod(GenPasswd::mod_pronounce);
	else if (int_filterCheckBox->isChecked())
		gen.setMod(GenPasswd::mod_filter);
	if (gen.getMod() != GenPasswd::mod_pronounce) {
		gen.setCharset(int_charLowerCheckBox->isChecked(),
			       int_charUpperCheckBox->isChecked(),
			       int_charNumCheckBox->isChecked(),
			       int_charSpecCheckBox->isChecked(),
			       int_charBlankCheckBox->isChecked(),
			       int_charUserCheckBox->isChecked() ?
					int_userDefLineEdit->text() :
					QString());
	}
	QString pw(gen.gen());
	if (pw.isEmpty())
		return false;
	password = pw;
	return true;
}

bool PwGenWndImpl::optionsSanityExtGen()
{
	if (ext_cmdLineEdit->text().isEmpty())
		return false;
	return true;
}

bool PwGenWndImpl::startExtGen()
{
	if (PwMGlobal::rootAlertMsgBox(this))
		return false;
	GenPasswd_extern gen;
	gen.setCmd(ext_cmdLineEdit->text());
	QString pw(gen.gen());
	if (pw.isEmpty()) {
		QString error(gen.getError());
		if (error.isEmpty()) {
			KMessageBox::error(this,
					   i18n("The external generator program "
						"executed properly, but did not write "
						"any data to the Standard Output (stdout)."),
					   i18n("No Password Provided"));
		} else {
			KMessageBox::error(this,
					   error,
					   i18n("External Generator Error"));
		}
		return false;
	}
	password = pw;
	return true;
}

QString PwGenWndImpl::getPassword()
{
	QString ret(password);
	password = QString();
	return ret;
}

void PwGenWndImpl::updateQualityBar_slot()
{
	const int lowercaseCredits = 15;
	const int uppercaseCredits = 15;
	const int numberCredits = 5;
	const int specialCredits = 5;
	const int blankCredits = 1;
	const int userCredits = 1;
	const int filterCredits = -2;

	int credits;
	int maxCredits;

	if (int_pronounceableCheckBox->isChecked()) {
		credits = 1;
		maxCredits = 20;
	} else {
		credits = 0;
		maxCredits = 500;
		if (int_charLowerCheckBox->isChecked())
			credits += lowercaseCredits;
		if (int_charUpperCheckBox->isChecked())
			credits += uppercaseCredits;
		if (int_charNumCheckBox->isChecked())
			credits += numberCredits;
		if (int_charSpecCheckBox->isChecked())
			credits += specialCredits;
		if (int_charBlankCheckBox->isChecked())
			credits += blankCredits;
		if (int_charUserCheckBox->isChecked())
			credits += userCredits * int_userDefLineEdit->text().length();
		if (int_filterCheckBox->isChecked())
			credits += filterCredits;
	}
	credits *= int_lenSpinBox->value();

	if (credits > maxCredits)
		credits = maxCredits;
	else if (credits < 0)
		credits = 0;
	int_qualityProgressBar->setProgress(credits, maxCredits);
}
