/***************************************************************************
 *                                                                         *
 *   copyright (C) 2003, 2004, 2005  by Michael Buesch                     *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kstandarddirs.h>

#include "pwmexception.h"
#include "pwminit.h"

#define LICENSE_FILE	(::locate("data", "pwmanager/pwmanager_license_text"))

int PwMApplication::newInstance()
{
	static bool initial = true;
	if (initial) {
		initial = false;
		init = new PwMInit(this);
		init->initializeApp();
	} else {
		BUG_ON(!init);
		printInfo("Receiving commandline arguments...");
		init->handleCmdLineArgs(false);
	}
	return EXIT_SUCCESS;
}


static const char *description = PROG_NAME " " PACKAGE_VER " '" PROG_NICKNAME "'\n"
				 I18N_NOOP("The convenient way of managing passwords");

static KCmdLineOptions options[] =
{
	{ "minimized",		I18N_NOOP("Windows minimized"),		0 },
	{ "mintray",		I18N_NOOP("Windows minimized to tray"),	0 },
	{ "open-deeplocked",	I18N_NOOP("Open all \"files\" deeplocked"),	0 },
	{ "+[files...]",	I18N_NOOP("Files to open on startup"),		0 },
	{ 0, 0, 0 }
};

#ifdef PWM_DEBUG
static void printDebugConfigureInfo()
{
	cout << "============================================" << endl;
	cout << PROG_NAME " version " PACKAGE_VER << endl;
#ifdef CONFIG_PWMANAGER_SMARTCARD
	cout << "CONFIG_PWMANAGER_SMARTCARD:    enabled" << endl;
#else
	cout << "CONFIG_PWMANAGER_SMARTCARD:    disabled" << endl;
#endif
#ifdef CONFIG_KWALLETIF
	cout << "CONFIG_KWALLETIF:              enabled" << endl;
#else
	cout << "CONFIG_KWALLETIF:              disabled" << endl;
#endif
#ifdef BIG_ENDIAN_HOST
	cout << "Endianess:                     big-endian" << endl;
#else
	cout << "Endianess:                     little-endian" << endl;
#endif
	cout << "sizeof(long):                  " << sizeof(long) << endl;
	cout << "============================================" << endl;
}
#else // PWM_DEBUG
static inline void printDebugConfigureInfo() { /* nothing */ }
#endif // PWM_DEBUG

static void addAuthors(KAboutData *aboutData)
{
	aboutData->addAuthor("Michael Buesch",
			     I18N_NOOP(
			     "Main programming and current maintainer."),
			     "mbuesch@freenet.de");
	aboutData->addAuthor("Matt Scifo",
			     I18N_NOOP(
			     "Original implementaion of \n"
			     "\"categories\" and the password-tree \n"
			     "in the system-tray. Original implementations of \n"
			     "numerous view-improvements."),
			     "mscifo@o1.com");
	aboutData->addCredit("Elias Probst",
			     I18N_NOOP(
			     "Gentoo ebuild maintainer."),
			     "elias.probst@gmx.de");
	aboutData->addCredit("George Staikos",
			     I18N_NOOP("KWallet"),
			     "staikos@kde.org");
	aboutData->addCredit("Matthew Palmer",
			     I18N_NOOP("rc2 code"),
			     "mjp16@uow.edu.au");
        aboutData->addCredit("Olivier Sessink",
			     I18N_NOOP("GPasman"),
			     "gpasman@nl.linux.org");
	aboutData->addCredit("The libgcrypt developers",
			     I18N_NOOP("Blowfish and SHA1 algorithms"),
			     0, "ftp://ftp.gnupg.org/gcrypt/alpha/libgcrypt/");
	aboutData->addCredit("Troy Engel",
			     I18N_NOOP("KPasman"),
			     "tengel@sonic.net");
	aboutData->addCredit("Wickey",
			     I18N_NOOP("Graphics-design in older versions."),
			     "wickey@gmx.at");
	aboutData->addCredit("Ian MacGregor",
			     I18N_NOOP(
			     "Documentation and application icon author."),
			     "greatscot@zipcon.com");
}

int main(int argc, char *argv[])
{
	printDebugConfigureInfo();
	KAboutData aboutData(PACKAGE_NAME, PROG_NAME,
			     PACKAGE_VER, description, KAboutData::License_File,
			     "(c) 2003, 2004, 2005 Michael Buesch and the PwManager Team", 0,
			     "http://passwordmanager.sourceforge.net/",
			     "mbuesch@freenet.de");
	addAuthors(&aboutData);

	KCmdLineArgs::init(argc, argv, &aboutData);
	KCmdLineArgs::addCmdLineOptions(options);

	KUniqueApplication::addCmdLineOptions();
	if (!KUniqueApplication::start()) {
		printInfo("already running.");
		return EXIT_SUCCESS;
	}
	PwMApplication a;
	aboutData.setLicenseTextFile(LICENSE_FILE);
	return a.exec();
}
