/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#include "paramwnd.h"

#include <qlabel.h>
#include <qlineedit.h>
#include <qhbox.h>
#include <qpushbutton.h>

#include <kapplication.h>

#include <time.h>

using namespace KWallet;


ParamWnd::ParamWnd(const char *_funcId,
		   QWidget *parent, const char *name, WFlags f)
 : QWidget(parent, name, f)
{
	okQuit = false;
	funcId = _funcId;
	setCaption("function parameter");
	vbox = new QVBox(this);
	new QLabel(QString(funcId) + "\nrequests the function parameter:", vbox);
	resize(QSize(650, 250));
}

ParamWnd::~ParamWnd()
{
	delete vbox;
}

void ParamWnd::closeEvent(QCloseEvent *e)
{
	okQuit = true;
	e->accept();
}

void ParamWnd::resizeEvent(QResizeEvent *)
{
	vbox->resize(size());
}

void ParamWnd::addButtons()
{
	QPushButton *b = new QPushButton("Ok", vbox);
	connect(b, SIGNAL(clicked()), this, SLOT(okButton()));
}

void ParamWnd::okButton()
{
	close();
}

void ParamWnd::wait()
{
	const struct timespec t = { 0, 100 };
	do {
		kapp->processEvents();
		nanosleep(&t, 0);
	} while (!okQuit);
}

QString ParamWnd::open_QString(const char *paramId)
{
	new QLabel(paramId, vbox);
	QLineEdit *ed = new QLineEdit(vbox);
	addButtons();
	show();
	wait();
	return ed->text();
}

QCString ParamWnd::open_QCString(const char *paramId)
{
	return (open_QString(paramId).latin1());
}

bool ParamWnd::open_bool(const char *paramId)
{
	new QLabel(paramId, vbox);
	new QLabel("type \"1\" for \"true\" and \"0\" for \"false\"", vbox);
	QLineEdit *ed = new QLineEdit(vbox);
	addButtons();
	show();
	wait();
	if (ed->text() == "0")
		return false;
	return true;
}

Wallet::OpenType ParamWnd::open_OpenType(const char *paramId)
{//TODO
}

Wallet::EntryType ParamWnd::open_EntryType(const char *paramId)
{//TODO
}

WId ParamWnd::open_WId(const char *paramId)
{
	new QLabel(paramId, vbox);
	QLineEdit *ed = new QLineEdit(vbox);
	addButtons();
	show();
	wait();
	//TODO
}

QByteArray ParamWnd::open_QByteArray(const char *paramId)
{
	new QLabel(paramId, vbox);
	new QLabel("The following QString will be converted into a QByteArray!", vbox);
	QLineEdit *ed = new QLineEdit(vbox);
	addButtons();
	show();
	wait();
	QByteArray ret;
	QDataStream ds(ret, IO_WriteOnly);
	ds << ed->text();
	return ret;
}

QMap<QString,QString> ParamWnd::open_QMap_QString_QString(const char *paramId)
{//TODO
}

#include "paramwnd.moc"
