/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef __GENPASSWD_H
#define __GENPASSWD_H

#include <qstring.h>
#include <qptrlist.h>

/** internal password generator of PwManager */
class GenPasswd
{
public:
	enum Modification
	{
		mod_none,
		mod_filter,
		mod_pronounce
	};

protected:
	struct dynCharset_element
	{
		dynCharset_element()
			 : refCnt (0)
			{ }
		/** charset data */
		QString data;
		/** reference counter for the filter */
		unsigned int refCnt;
	};

public:
	GenPasswd();

	/** set the charset to use */
	void setCharset(bool lower,
			bool upper,
			bool num,
			bool special,
			bool blank,
			QString user);
	/** set the password length */
	void setLen(int len)
			{ length = len; }
	/** set the modification type */
	void setMod(Modification _mod)
			{ mod = _mod; }
	/** get the modification type */
	Modification getMod()
			{ return mod; }
	/** start to generate a new password and return it.
	  * Returns an empty string on error.
	  */
	QString gen();

protected:
	/** generate a regular password. */
	QString genRegular();
	/** generate a pronounceable password. */
	QString genPronounceable();
	/** randomize the dynamic charset */
	void rndDynCharset();
	/** select the next charset (based on useFilter) */
	dynCharset_element * selectNextCharset();
	/** generate a new random char from the given charset */
	QChar genNewRandom(const dynCharset_element *charset);

protected:
	/** password length to generate */
	int length;
	/** current modification mode. */
	Modification mod;
	/** dynamic charset used for generating the password */
	QPtrList<dynCharset_element> dynCharset;
};

#endif // __GENPASSWD_H
